<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Twig;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Filesystem\FileFilesystem;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Filesystem\GiftFilesystem;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Filesystem\ImageFilesystem;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class FileExtension extends AbstractExtension
{

    private $imageFilesystem;
    private $fileFilesystem;
    private $giftFilesystem;
    private $kernelRootDir;

    public function __construct(ImageFilesystem $imageFilesystem, FileFilesystem $fileFilesystem, GiftFilesystem $giftFilesystem, $kernelRootDir)
    {
        $this->imageFilesystem = $imageFilesystem;
        $this->fileFilesystem  = $fileFilesystem;
        $this->giftFilesystem  = $giftFilesystem;
        $this->kernelRootDir   = $kernelRootDir;
    }

    public function getFilters()
    {
        return [
            new TwigFilter('file_path', [$this, 'filePathFilter']),
            new TwigFilter('image_path', [$this, 'imagePathFilter']),
        ];
    }

    public function filePathFilter($path)
    {

        return str_replace($this->kernelRootDir.'/../public', '', $this->fileFilesystem->getAdapter()->getPathPrefix().$path);
    }

    public function imagePathFilter($path)
    {

        return str_replace($this->kernelRootDir.'/../public', '', $this->imageFilesystem->getAdapter()->getPathPrefix().$path);
    }

    public function giftPathFilter($path)
    {

        return str_replace($this->kernelRootDir.'/../public', '', $this->giftFilesystem->getAdapter()->getPathPrefix().$path);
    }

    public function filePathAbsoluteFilter($path)
    {

        return $this->fileFilesystem->getAdapter()->getPathPrefix().$path;
    }

    public function imagePathAbsoluteFilter($path)
    {

        return $this->imageFilesystem->getAdapter()->getPathPrefix().$path;
    }

    public function giftPathAbsoluteFilter($path)
    {

        return $this->giftFilesystem->getAdapter()->getPathPrefix().$path;
    }
}