<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslatedEntityType;
use A2lix\TranslationFormBundle\Form\Type\TranslationsFormsType;
use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Award\Model\Award;
use CpCreation\VitiCore\Product\Model\Product;
use CpCreation\VitiCore\Product\Model\ProductCategory;
use CpCreation\VitiCore\Product\Model\ProductImage;
use CpCreation\VitiCore\Product\Model\ProductTypeOption;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Model\ProductVariant;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\ColorType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;

/**
 * @author Colinet Julien
 */
class ProductFormType extends AbstractType
{

    private $authorizationChecker;

    public function __construct(AuthorizationCheckerInterface $authorizationChecker)
    {
        $this->authorizationChecker = $authorizationChecker;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        if ($this->authorizationChecker->isGranted('ROLE_ADMIN') || $this->authorizationChecker->isGranted('ROLE_PRODUCT')) {
            $builder
                ->add(
                    'category', TranslatedEntityType::class, [
                        'label'                => 'Catégorie',
                        'class'                => ProductCategory::class,
                        'translation_property' => 'name',
                        'required'             => true,
                    ]
                )
                ->add(
                    'awards', TranslatedEntityType::class, [
                        'label'                => 'Type',
                        'class'                => Award::class,
                        'translation_property' => 'title',
                        'required'             => false,
                        'multiple'             => true,
                        'attr'                 => ["class" => "select2"],
                    ]
                )
                ->add(
                    'cuvee', CheckboxType::class, ['label' => 'Afficher dans les cuvées', 'required' => false]
                )
                ->add(
                    'shop', CheckboxType::class, ['label' => 'Afficher dans la boutique', 'required' => false]
                )
                ->add(
                    'favorite', CheckboxType::class, [
                        'label'    => 'Afficher dans la catégorie "Favoris" dans la boutique',
                        'required' => false,
                    ]
                )
                ->add(
                    'image', ImageType::class, ['label' => 'Image cuvée']
                )
                ->add(
                    'secondImage', ImageType::class, ['label' => 'Image boutique ( si différente image cuvée )']
                )
                ->add(
                    'backgroundImage', ImageType::class, ['label' => 'Image utilisé pour le background de la cuvée']
                )
                ->add(
                    'disabled', CheckboxType::class, ['label' => 'Dépublié', 'required' => false]
                )
                ->add(
                    'new', CheckboxType::class, ['label' => 'Nouveauté', 'required' => false]
                )
                ->add(
                    'soldOut', CheckboxType::class, ['label' => 'Désactiver les commandes', 'required' => false]
                )
                ->add(
                    'ribbonCustomColor', ColorType::class, [
                        'label'    => 'Couleur d\'arrière plan du ribbon',
                        'required' => false,
                    ]
                )
                ->add(
                    'enableColor', CheckboxType::class, [
                        'label'    => 'Activer la couleur du produit sur le nom du produit',
                        'required' => false,
                    ]
                )
                ->add(
                    'enableColorQuality', CheckboxType::class, [
                        'label'    => 'Activer la couleur du produit sur la qualité',
                        'required' => false,
                    ]
                )
                ->add(
                    'color', ColorType::class, ['label' => 'Couleur du produit', 'required' => false]
                )
                ->add(
                    'orderInFavorites', IntegerType::class, [
                        'label'    => 'Ordre dans la catégorie " Favoris" dans la partie boutique (le visuel par catégorie doit être activé)',
                        'required' => false,
                    ]
                )
                ->add(
                    'translations', TranslationsType::class, [
                        'label'           => false,
                        'fields'          => [
                            'header'        => [
                                'field_type' => TextType::class,
                                'label'      => 'Entête',
                                'required'   => false,
                            ],
                            'name'          => [
                                'field_type' => TextType::class,
                                'label'      => 'Nom',
                                'required'   => true,
                            ],
                            'quality'       => [
                                'field_type' => TextType::class,
                                'label'      => 'Qualité',
                                'required'   => false,
                            ],
                            'otherText1'    => [
                                'field_type' => TextType::class,
                                'label'      => 'Autre Texte 1',
                                'required'   => false,
                            ],
                            'ribbonCustom'  => [
                                'field_type' => TextType::class,
                                'label'      => 'Ribbon personnalisé',
                                'required'   => false,
                            ],
                            'description'   => [
                                'field_type' => TrumbowygType::class,
                                'label'      => 'Description principale du produit',
                                'required'   => false,
                            ],
                            'introText'     => [
                                'field_type' => TrumbowygType::class,
                                'label'      => 'Description supplémentaire',
                                'required'   => false,
                            ],
                            'infoShop'      => [
                                'field_type' => TrumbowygType::class,
                                'label'      => 'Information boutique (Ex: indiquer le contenu d\'un coffret)',
                                'required'   => false,
                            ],
                            'assemblages'   => [
                                'field_type'    => CollectionType::class,
                                'entry_type'    => AssemblageType::class,
                                'allow_add'     => true,
                                'allow_delete'  => true,
                                'prototype'     => true,
                                'by_reference'  => false,
                                'delete_empty'  => true,
                                'required'      => false,
                                'attr'          => [
                                    'data-name-prefix' => 'product',
                                    'class'            => "assemblage-collection",
                                ],
                                'entry_options' => ['label' => false],
                            ],
                            'dosage'        => [
                                'field_type' => TrumbowygType::class,
                                'label'      => 'Dosage en sucre',
                                'required'   => false,
                            ],
                            'tasting'       => [
                                'field_type' => TrumbowygType::class,
                                'label'      => 'Information de dégustation',
                                'required'   => false,
                            ],
                            'winemaking'    => [
                                'field_type'    => CollectionType::class,
                                'entry_type'    => AssemblageType::class,
                                'allow_add'     => true,
                                'allow_delete'  => true,
                                'prototype'     => true,
                                'by_reference'  => false,
                                'required'      => false,
                                'delete_empty'  => true,
                                'attr'          => [
                                    'data-name-prefix' => 'winemaking',
                                    'class'            => "assemblage-collection",
                                ],
                                'entry_options' => ['label' => false],
                            ],
                            'selectVariant' => [
                                'field_type' => TextType::class,
                                'label'      => 'Changer le texte de la selectBox (Choisir un contenant)',
                                'required'   => false,
                            ],
                        ],
                        'excluded_fields' => ['slug'],
                    ]
                )
                ->add(
                    'images', ImageCollectionType::class, [
                        'label'          => false,
                        'entry_type'     => ProductImageType::class,
                        'allow_add'      => true,
                        'allow_delete'   => true,
                        'error_bubbling' => false,
                        'prototype'      => true,
                        'by_reference'   => false,
                        'delete_empty'   => true,
                        'attr'           => [
                            'data-name-prefix' => 'Image',
                            'class'            => "image-collection",
                        ],
                        'entry_options'  => [
                            'data_class' => ProductImage::class,
                            'label'      => false,
                        ],
                    ]
                )
                ->add(
                    'file', FileType::class, ['label' => 'Fiche', 'required' => false]
                )
                /*->add(
                    'files', TranslationsFormsType::class, [
                        'form_type' => ProductFileType::class,
                        'default_locale' => ['fr'],
                        'required_locales' => [],
                        'required' => false,
                        'label' => 'Fichier différent en fonction de la langue'
                    ]
                )*/
                ->add(
                    'groups', EntityType::class,
                    [
                        'class'         => ProductPriceGroup::class,
                        'query_builder' => function (ProductPriceGroupRepository $er) {
                            return $er->findByNameOrderAdminQuery();
                        },
                        'choice_label'  => 'name',
                        'label'         => 'Groupes de prix',
                        'multiple'      => true,
                        'required'      => true,
                        'attr'          => [
                            'class' => 'select2',
                        ],
                    ]
                );
            $builder
                ->add(
                    'variants', VariantCollectionType::class, [
                        'label'          => false,
                        'entry_type'     => ProductVariantType::class,
                        'allow_add'      => true,
                        'allow_delete'   => true,
                        'error_bubbling' => false,
                        'prototype'      => true,
                        'by_reference'   => false,
                        'delete_empty'   => true,
                        'attr'           => [
                            'data-name-prefix' => 'ProductVariant',
                            'class'            => "variant-collection",
                        ],
                        'entry_options'  => [
                            'data_class' => ProductVariant::class,
                            'label'      => false,
                        ],
                    ]
                );
        }
    }

    public
    function configureOptions(OptionsResolver $resolver
    ) {
        $resolver->setDefaults(
            [
                'data_class' => Product::class,
            ]
        );
    }
}
