<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\Payment;

use CpCreation\VitiCore\Cart\Model\Payment\SogeCommerce;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class SogeCommercePaymentType extends AbstractType implements PaymentMethodInterface, DataTransformerInterface
{
    const TYPE = 'sogecommerce';

    private $serializer;

    public function __construct()
    {
        $normalizers = [new ObjectNormalizer()];
        $this->serializer = new Serializer($normalizers);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name',TextType::class,
                [
                    'label' => 'Nom',
                    'required' => true
                ])
            ->add('mode',ChoiceType::class,
                [
                    'label' => 'Production',
                    'choices' => [
                        'production' => 'PRODUCTION',
                        'test' => 'TEST',
                    ],
                    'required' => true
                ])
            ->add('siteId',TextType::class,
                [
                    'label' => 'Identifiant de la boutique',
                    'required' => true
                ])
            ->add('key', TextType::class,
                [
                    'label' => 'Clé',
                    'required' => true
                ])
            ->add('hmacAlgo', ChoiceType::class, [
                'choices' => [
                    'SHA512' => 'sha512',
                    'SHA1' => 'sha1',
                    'SHA256' => 'sha256'
                ],
                'label'       => 'HMAC ALGO',
                'required'    => true
            ]);
        $builder->addModelTransformer($this);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => SogeCommerce::class
        ]);
    }

    public function getMethod()
    {
        return static::TYPE;
    }

    public function transform($data)
    {

        return $this->serializer->denormalize($data, SogeCommerce::class);
    }

    public function reverseTransform($data)
    {

        return $this->serializer->normalize($data);
    }

    public function getBlockPrefix()
    {
        return 'sogecommerce_payment';
    }
}
