<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\Depot\Repository\CategoryRepository;
use CpCreation\VitiCore\Event\Repository\EventRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;

class DepotSalonController extends AbstractController
{
    private $categoryRepository;
    private $eventRepository;

    public function __construct(CategoryRepository $categoryRepository, EventRepository $eventRepository)
    {
        $this->categoryRepository = $categoryRepository;
        $this->eventRepository = $eventRepository;
    }

    /**
     * @param Request $request
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Request $request)
    {
        $categories = $this->categoryRepository->findCategories();
        $salons     = $this->eventRepository->findBy(['disabled' => false], ['beginAt' => 'ASC']);

        return $this->render(
            'depotsalon.html.twig',
            [
                'classMenu'  => 'black',
                'categories' => $categories,
                'salons'     => $salons,
            ]
        );
    }

}
