<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ShippingPriceType;
use CpCreation\VitiCore\Shop\Model\ShippingPrice;
use CpCreation\VitiCore\Shop\Model\ShippingZone;
use CpCreation\VitiCore\Shop\Repository\ShippingPriceRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_SHIPPING')")
 * Class ShippingPriceController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/shipping-price")
 */
class ShippingPriceController extends AbstractController
{
    private $shippingPriceRepository;

    public function __construct(ShippingPriceRepository $shippingPriceRepository)
    {
        $this->shippingPriceRepository =  $shippingPriceRepository;
    }

    /**
     * @route("", name="admin_shipping_price")
     * @Template("@CpCreationVitiCore/admin/shipping/price/index.html.twig")
     */
    public function indexAction()
    {
        $prices = $this->shippingPriceRepository->findOrder();

        return [
            "items" => $prices,
        ];
    }


    /**
     * @param Request $request
     * @Route("/new", name="admin_shipping_price_new")
     * @Template("@CpCreationVitiCore/admin/shipping/price/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(ShippingPriceType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ShippingZone $data */
            $data = $form->getData();
            $this->shippingPriceRepository->save($data);
            $this->addFlash('alert-success', 'Le prix a été ajouté avec succès');

            return $this->redirectToRoute('admin_shipping_price');

        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ShippingPrice $price
     * @param Request $request
     * @Route("/{id}/edit", name="admin_shipping_price_edit")
     * @Template("@CpCreationVitiCore/admin/shipping/price/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(ShippingPrice $price, Request $request)
    {
        $form = $this->createForm(ShippingPriceType::class, $price);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ShippingPrice $data */
            $data = $form->getData();
            $this->shippingPriceRepository->save($data);
            $this->addFlash('alert-success', 'La prix a été modifié avec succès');

            return $this->redirectToRoute('admin_shipping_price');

        }

        return [
            "item" => $price,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ShippingPrice $price
     * @Route("/{id}/delete", name="admin_shipping_price_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(ShippingPrice $price)
    {
        $this->shippingPriceRepository->delete($price);
        $this->addFlash('alert-success', 'Le prix a été supprimé avec succès.');

        return $this->redirectToRoute('admin_shipping_price');
    }
}
