<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;


use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ShippingAdditionalType;
use CpCreation\VitiCore\Shop\Model\ShippingAdditional;
use CpCreation\VitiCore\Shop\Repository\ShippingAdditionalRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_SHIPPING')")
 * Class ShippingAdditionalController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/shipping-additionnal")
 */
class ShippingAdditionalController extends AbstractController
{
    private $shippingAdditionalRepository;

    public function __construct(ShippingAdditionalRepository $shippingAdditionalRepository)
    {
        $this->shippingAdditionalRepository =  $shippingAdditionalRepository;
    }

    /**
     * @route("", name="admin_shipping_additional")
     * @Template("@CpCreationVitiCore/admin/shipping/additional/index.html.twig")
     */
    public function indexAction()
    {
        $additionals = $this->shippingAdditionalRepository->findBy([],['qtyAt' => 'ASC']);

        return [
            "items" =>  $additionals,
        ];
    }


    /**
     * @param Request $request
     * @Route("/new", name="admin_shipping_additional_new")
     * @Template("@CpCreationVitiCore/admin/shipping/additional/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(ShippingAdditionalType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ShippingAdditional $data */
            $data = $form->getData();
            $this->shippingAdditionalRepository->save($data);
            $this->addFlash('alert-success', 'Le supplément a été ajouté avec succès');

            return $this->redirectToRoute('admin_shipping_additional');

        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ShippingAdditional $price
     * @param Request $request
     * @Route("/{id}/edit", name="admin_shipping_additional_edit")
     * @Template("@CpCreationVitiCore/admin/shipping/additional/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(ShippingAdditional $price, Request $request)
    {
        $form = $this->createForm(ShippingAdditionalType::class, $price);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ShippingAdditional $data */
            $data = $form->getData();
            $this->shippingAdditionalRepository->save($data);
            $this->addFlash('alert-success', 'Le supplément a été modifié avec succès');

            return $this->redirectToRoute('admin_shipping_additional');

        }

        return [
            "item" => $price,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ShippingAdditional $price
     * @Route("/{id}/delete", name="admin_shipping_additional_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(ShippingAdditional $price)
    {
        $this->shippingAdditionalRepository->delete($price);
        $this->addFlash('alert-success', 'Le supplément a été supprimé avec succès.');

        return $this->redirectToRoute('admin_shipping_additional');
    }
}
