<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Doctrine\EventSubscriber;

use CpCreation\VitiCore\Product\Model\ProductType;
use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Events;

class ProductTypeSubscriber implements EventSubscriber
{
    public function getSubscribedEvents()
    {
        return [
            Events::prePersist,
             Events::preUpdate
        ];
    }

    /**
     * @param LifecycleEventArgs $args
     */
    public function prePersist(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();
        if ($entity instanceof ProductType) {
            if (!$entity->getMultipleQuantityDepot() || $entity->getMultipleQuantityDepot() == 0) {
                $entity->setMultipleQuantityDepot($entity->getMultipleQuantityCart());
            }
        }
    }

    /**
     * @param LifecycleEventArgs $args
     */
    public function preUpdate(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();
        if ($entity instanceof ProductType) {
            if (!$entity->getMultipleQuantityDepot() || $entity->getMultipleQuantityDepot() == 0) {
                $entity->setMultipleQuantityDepot($entity->getMultipleQuantityCart());
            }
        }
    }
}
