<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Contact\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Knp\DoctrineBehaviors\Contract\Entity\TranslationInterface;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;

/**
 * Class LabelTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="contact_label_translation")
 * @ORM\HasLifecycleCallbacks()
 */
class LabelTranslation implements TranslationInterface
{
    use Translation;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;
    
    /**
     * @var string
     * @ORM\Column(type="text", nullable=true)
     *
     */
    private $text;

    public function __construct()
    {
        $this->id       = Uuid::uuid4();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }
    
    /**
     * @return string
     */
    public function getText(): ?string
    {
        return $this->text;
    }

    /**
     * @param string $text
     */
    public function setText(string $text = null): void
    {
        $this->text = $text;
    }
}
