<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;

class ContactType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $builder
            ->add('lastname', TextType::class, [
                'required' => true,
                'label'    => false,
                'attr'     => ['placeholder' => 'contact.form.name', 'autocomplete' => 'name'],
                'constraints' => [new NotBlank()]
            ])
            ->add('email', EmailType::class, [
                'required' => true,
                'label'    => false,
                'attr'     => ['placeholder' => 'contact.form.email',  'autocomplete' => 'email' ],
                'constraints' => [new NotBlank()]
            ])
            ->add('message', TextareaType::class, [
                'required' => true,
                'label'    => false,
                'attr'     => ['placeholder' => 'contact.form.message', 'rows' => 8],
                'constraints' => [new NotBlank()]
            ])
        ;
    }
}