<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Media\Model\Image;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class ImageType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'file', FileType::class, [
                    'label' => false,
                    'attr'  => [
                        'class' => 'input_image',
                    ],
                ]
            )
            ->addEventListener(
                FormEvents::PRE_SET_DATA,
                [$this, 'onPreSetData']
            );
    }

    public function onPreSetData(FormEvent $event)
    {
        /** @var Image $image */
        $image = $event->getData();
        $form  = $event->getForm();
        if ($event->getData())
        {
            if ($image->getPath()) {
                $form->remove('file');
                $form->add(
                    'file', FileType::class, [
                        'label'    => false,
                        'required' => false,
                        'attr'     => [
                            'class' => 'input_image',
                        ],
                    ]
                );
            }
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults
        (
            [
                'data_class' => Image::class,
                'required'   => false,
            ]
        );
    }
}
