<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Gite\Model\Gite;
use CpCreation\VitiCore\Gite\Model\GiteImage;
use CpCreation\VitiCore\Gite\Model\Room;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class GiteType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'translations', TranslationsType::class, [
                    'label'           => false,
                    'fields'          => [
                        'title'       => [
                            'field_type' => TextType::class,
                            'label'      => 'Titre',
                            'required'   => true,
                        ],
                        'subtitle'    => [
                            'field_type' => TextType::class,
                            'label'      => 'Sous-Titre',
                            'required'   => false,
                        ],
                        'description' => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Description',
                            'required'   => true,
                        ],
                        'price'       => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Tarifs et réservations',
                            'required'   => true,
                        ],
                    ],
                    'excluded_fields' => ['slug'],
                ]
            )
            ->add(
                'images', ImageCollectionType::class, [
                    'label'          => false,
                    'entry_type'     => GiteImageType::class,
                    'allow_add'      => true,
                    'allow_delete'   => true,
                    'error_bubbling' => false,
                    'prototype'      => true,
                    'by_reference'   => false,
                    'delete_empty'   => true,
                    'attr'           => [
                        'data-name-prefix' => 'Image',
                        'class'            => "image-collection",
                    ],
                    'entry_options'  => [
                        'data_class' => GiteImage::class,
                        'label'      => false,
                    ],
                ]
            )
            ->add(
                'rooms', RoomCollectionType::class, [
                    'label'          => false,
                    'entry_type'     => RoomType::class,
                    'allow_add'      => true,
                    'allow_delete'   => true,
                    'prototype'      => true,
                    'by_reference'   => false,
                    'delete_empty'   => true,
                    'attr'           => [
                        'data-name-prefix' => 'Room',
                        'class'            => "room-collection",
                    ],
                    'entry_options'  => [
                        'data_class' => Room::class,
                        'label'      => false,
                    ],
                ]
            )
            ->add(
                'video', VideoType::class, ['label' => 'Vidéo ( Numéro de la vidéo, ex : nFoT4Z-0HIQ )', 'required' => false ]
            )
            ->add(
                'image', ImageType::class, ['label' => 'Label ( épi, clefs, etc )', 'required' => false]
            )
            ->add(
                'file', FileType::class, ['label' => 'Fiche', 'required' => false]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => Gite::class,
            ]
        );
    }
}
