<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Faker\Provider;

use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Model\ProductType;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Product\Repository\ProductTypeRepository;
use Faker\Generator;
use Faker\Provider\Base as BaseProvider;

class VitiCoreProvider extends BaseProvider
{
    private $productPriceGroupRepository;
    private $productTypeRepository;

    public function __construct(Generator $generator,
        ProductPriceGroupRepository $productPriceGroupRepository,
        ProductTypeRepository $productTypeRepository
    ) {
        $this->productPriceGroupRepository = $productPriceGroupRepository;
        $this->productTypeRepository       = $productTypeRepository;
        parent::__construct($generator);
    }

    /**
     * @return ProductPriceGroup[]|object[]
     */
    public function groups()
    {
        $groups = $this->productPriceGroupRepository->findAll();

        return $groups;
    }

    /**
     * @return array|ProductType[]|object[]
     */
    public function getTypeBottle()
    {
        $types = $this->productTypeRepository->findBy(['equivalencyDefault' => true]);

        return $types;
    }

}