<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\Gite\Repository\GiteRepository;
use CpCreation\VitiCore\Newsletter\Repository\NewsletterRepository;
use CpCreation\VitiCore\Popup\Repository\PopupRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

class HomepageController extends AbstractController
{

    private $popupRepository;
    private $newsletterRepository;
    private $giteRepository;
    private $session;

    public function __construct(PopupRepository $popupRepository,
        NewsletterRepository $newsletterRepository,
        GiteRepository $giteRepository,
        SessionInterface $session
    ) {
        $this->popupRepository      = $popupRepository;
        $this->newsletterRepository = $newsletterRepository;
        $this->giteRepository       = $giteRepository;
        $this->session              = $session;
    }

    /**
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction()
    {
        $popup      = $this->popupRepository->findOneOrNull();
        $newsletter = $this->newsletterRepository->findLastNewsletter();
        $cottages   = $this->giteRepository->findAll();
        $subMenu    = null;

        if ($newsletter) {
            $subMenu = true;
        }

        return $this->render(
            'homepage.html.twig',
            [
                'popup'      => $popup,
                'newsletter' => $newsletter,
                'subMenu'    => $subMenu,
                'cottages'   => $cottages,
            ]
        );
    }
}
