<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site\CartType;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site\CheckCodePriceType;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Payment\MoneticoPayment;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Payment\SherlockPayment;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Payment\SogeCommercePayment;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Payment\SystemPayPayment;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Service\SherlockService;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils\CalculDegressive;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils\CalculShipping;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils\Mailer;
use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Cart\Model\CartItem;
use CpCreation\VitiCore\Cart\Model\InvoiceAddress;
use CpCreation\VitiCore\Cart\Model\Promo;
use CpCreation\VitiCore\Cart\Repository\CartRepository;
use CpCreation\VitiCore\Cart\Repository\PromoRepository;
use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use CpCreation\VitiCore\Payment\Model\Payment;
use CpCreation\VitiCore\Payment\Repository\PaymentRepository;
use CpCreation\VitiCore\Product\Model\Product;
use CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Shop\Model\ShippingCountry;
use CpCreation\VitiCore\Shop\Repository\ShippingCountryRepository;
use CpCreation\VitiCore\Shop\Repository\ShippingCountyRepository;
use CpCreation\VitiCore\Shop\Repository\ShippingZoneRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

class CartController extends AbstractController
{
    private $calculShipping;
    private $calculDegressive;
    private $promoRepository;
    private $productPriceCodeRepository;
    private $productPriceGroupRepository;
    private $cartRepository;
    private $paymentRepository;
    private $contactRepository;
    private $router;
    private $translator;
    private $mailer;
    private $moneticoPayment;
    private $sherlockPayment;
    private $shippingCountryRepository;
    private $shippingCountyRepository;
    private $shippingZoneRepository;
    private $em;
    private $sherlockFinder;
    private $sherlock_dir;
    private $systempayPayment;
    private $sogeCommercePayment;
    private $session;

    public function __construct(CalculShipping $calculShipping,
        CalculDegressive $calculDegressive,
        PromoRepository $promoRepository,
        ProductPriceCodeRepository $productPriceCodeRepository,
        ProductPriceGroupRepository $productPriceGroupRepository,
        ShippingCountryRepository $shippingCountryRepository,
        ShippingCountyRepository $shippingCountyRepository,
        ShippingZoneRepository $shippingZoneRepository,
        CartRepository $cartRepository,
        PaymentRepository $paymentRepository,
        ContactRepository $contactRepository,
        RouterInterface $router,
        TranslatorInterface $translator,
        Mailer $mailer,
        MoneticoPayment $moneticoPayment,
        SherlockPayment $sherlockPayment,
        SherlockService $sherlockService,
        $sherlockDir,
        SystemPayPayment $systemPayPayment,
        SogeCommercePayment $sogeCommercePayment,
        EntityManagerInterface $em,
        SessionInterface $session
    ) {
        $this->calculShipping              = $calculShipping;
        $this->calculDegressive            = $calculDegressive;
        $this->promoRepository             = $promoRepository;
        $this->productPriceCodeRepository  = $productPriceCodeRepository;
        $this->productPriceGroupRepository = $productPriceGroupRepository;
        $this->shippingCountryRepository   = $shippingCountryRepository;
        $this->shippingCountyRepository    = $shippingCountyRepository;
        $this->shippingZoneRepository      = $shippingZoneRepository;
        $this->cartRepository              = $cartRepository;
        $this->paymentRepository           = $paymentRepository;
        $this->contactRepository           = $contactRepository;
        $this->router                      = $router;
        $this->translator                  = $translator;
        $this->mailer                      = $mailer;
        $this->moneticoPayment             = $moneticoPayment;
        $this->em                          = $em;
        $this->sherlockPayment             = $sherlockPayment;
        $this->sherlockFinder              = $sherlockService;
        $this->sherlock_dir                = $sherlockDir;
        $this->systempayPayment            = $systemPayPayment;
        $this->sogeCommercePayment         = $sogeCommercePayment;
        $this->session                     = $session;

    }

    /**
     * @param Request $request
     * @Route("/request/calcul_shipping", options={"expose"=true}, name="calcul_shipping")
     *
     * @return JsonResponse
     */
    public
    function shippingCalculAction(Request $request
    ) {
        $form = $this->createForm(CartType::class);
        $form->handleRequest($request);
        /**
         * @var Cart $cart
         */
        $cart = $form->getData();
        try {
            $shipping = $this->calculShipping->shippingTotalPrice($cart);

            return new JsonResponse($shipping['amount'], 200);
        } catch (\Exception $e) {

            return new JsonResponse($e->getMessage(), 400);
        }
    }

    /**
     * @param Request $request
     *
     * @Route("/request/promo_code", options={"expose"=true}, name="promo_code")
     *
     * @return JsonResponse
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public
    function CodePromoAction(Request $request
    ) {

        $locale = $request->getLocale();
        $form   = $this->createForm(CartType::class);
        $form->handleRequest($request);
        /** @var Cart $cart */
        $cart         = $form->getData();
        $withShipping = false;
        /** @var Promo $promo */
        $promo = $this->promoRepository->findPromoActivWithCode($cart, $this->session->get('groupPrice', null));
        if ($promo) {
            if ($promo->getZones()->count() > 0) {
                if (!$cart->getInvoiceAddress()->getPostalCode() || !$cart->getInvoiceAddress()->getCountry()) {
                    return new JsonResponse(
                        [
                            'value'       => null,
                            'valueAmount' => null,
                            'message'     => $this->translator->trans('shop.promo_code.empty_zone', [], null, $locale),
                        ], 400
                    );
                }
                /** @var ShippingCountry $country */
                $country = $this->shippingCountryRepository->findOneByGroup($cart->getDeliveryAddress()->getCountry(), $this->session->get('groupPrice', null));
                $county = null;
                if ($country->isCounty()) {
                    $department = substr($cart->getDeliveryAddress()->getPostalCode(), 0, 2);
                    $county     = $this->shippingCountyRepository->findDepartmentByCountry($department, $country->getCode());
                }
                $zone = $this->shippingZoneRepository->findByCountryAndByCounty($country, $county);
                $promo = $this->promoRepository->findPromoActivWithCode($cart, $this->session->get('groupPrice', null), $zone);
            }
            if ($promo) {
                if (!$promo->getMaxCount() || (($promo->getCount() < $promo->getMaxCount()))) {
                    if ($promo->getProducts()->count() > 0) {
                        $errorProducts = '';
                        /** @var Product $product */
                        $quantity = $cart->getQuantityByProducts($promo->getProducts());
                        foreach ($promo->getProducts() as $key => $product) {
                            if ($key === 0) {
                                $errorProducts .= $product->getName().' '.$product->getQuality();
                            } else {
                                $errorProducts .= ' ou '.$product->getName().' '.$product->getQuality();
                            }

                            $productCount = 1;
                        }

                    } else {
                        $quantity      = $cart->getQuantityAllAbsolute();
                        $errorProducts = null;
                        $productCount  = 0;
                    }

                    if ($promo->getMinEquivalency() && $quantity < $promo->getMinEquivalency()) {
                        return new JsonResponse(
                            [
                                'value'       => null,
                                'valueAmount' => null,
                                'message'     => $this->translator->transChoice(
                                    'shop.promo_code.qty_error', $productCount, [
                                    '%qty%'      => $promo->getMinEquivalency(),
                                    '%products%' => $errorProducts,
                                ], null, $locale
                                ),
                            ], 400
                        );
                    }

                    if ($promo->getPercent() && $promo->isIncludeShippingFees()) {
                        $withShipping = true;
                    }
                    if ($promo->getPercentShippingCost()) {
                        $shippingCost = $this->calculShipping->shippingTotalPrice($cart);
                        $promoAmount  = ceil($shippingCost['amount'] * $promo->getPercentShippingCost());
                    } else {
                        if ($promo->isMultipleByQuantity()) {
                            $promoAmount = $promo->getAmount() * floor($quantity / $promo->getMinEquivalency());
                        } else {
                            $promoAmount = $promo->getAmount();
                        }
                    }

                    return new JsonResponse(
                        [
                            'valuePercent' => $promo->getPercent(),
                            'valueAmount'  => $promoAmount,
                            'withShipping' => $withShipping,
                            'message'      => $this->translator->trans('shop.promo_code.success', [], null, $locale),
                        ], 200
                    );
                } else {
                    return new JsonResponse(
                        [
                            'value'        => null,
                            'valueAmount'  => null,
                            'withShipping' => $withShipping,
                            'message'      => $this->translator->trans('shop.promo_code.count_error', [], null, $locale),
                        ], 400
                    );
                }
            }else{
                return new JsonResponse(
                    [
                        'value'       => null,
                        'valueAmount' => null,
                        'message'     => $this->translator->trans('shop.promo_code.error_zone', [], null, $locale),
                    ], 400
                );
            }
        } else {
            return new JsonResponse(
                [
                    'value'        => null,
                    'valueAmount'  => null,
                    'withShipping' => $withShipping,
                    'message'      => $this->translator->trans('shop.promo_code.error', [], null, $locale),
                ], 400
            );
        }
    }

    /**
     * @param Request $request
     * @Route("/request/promo_code_auto", options={"expose"=true}, name="promo_code_auto")
     */
    public function CodePromoAutoAction(Request $request)
    {
        $locale = $request->getLocale();
        $form   = $this->createForm(CartType::class);
        $form->handleRequest($request);
        /** @var Cart $cart */
        $cart = $form->getData();

        if ($cart->getInvoiceAddress()->getEmail() && $cart->getInvoiceAddress()->getPhone() && $cart->getInvoiceAddress()->getPostalCode() && $cart->getInvoiceAddress()->getCountry()) {

            /** @var ShippingCountry $country */
            $country = $this->shippingCountryRepository->findOneByGroup($cart->getDeliveryAddress()->getCountry(), $this->session->get('groupPrice', null));
            $county = null;
            if ($country->isCounty()) {
                $department = substr($cart->getDeliveryAddress()->getPostalCode(), 0, 2);
                $county     = $this->shippingCountyRepository->findDepartmentByCountry($department, $country->getCode());
            }
            $zone = $this->shippingZoneRepository->findByCountryAndByCounty($country, $county);
            /** @var Promo $promo */
            $promo = $this->promoRepository->findPromoActivAutoWithGroup($cart, $this->session->get('groupPrice', null), $zone);

            if ($promo && (!$promo->getMaxCount() || ($promo->getCount() < $promo->getMaxCount()))) {

                if ($promo->getProducts()->count() > 0) {
                    $quantity = $cart->getQuantityByProducts($promo->getProducts());
                } else {
                    $quantity = $cart->getQuantityAllAbsolute();
                }

                $countByUser = $this->cartRepository->countPromoByUser($promo, $cart);
                if (!$promo->getMaxCountByCustomer() || ($promo->getMaxCountByCustomer() > count($countByUser))) {

                    if ($promo->getPercentShippingCost()) {
                        $shippingCost = $this->calculShipping->shippingTotalPrice($cart);
                        $promoAmount  = ceil($shippingCost['amount'] * $promo->getPercentShippingCost());
                    } else {
                        if ($promo->isMultipleByQuantity()) {
                            $promoAmount = $promo->getAmount() * floor($quantity / $promo->getMinEquivalency());
                        } else {
                            $promoAmount = $promo->getAmount();
                        }
                    }

                    return new JsonResponse(
                        [
                            'valuePercent' => $promo->getPercent(),
                            'valueAmount'  => $promoAmount,
                            'message'      => $this->translator->trans('shop.promo_code.success', [], null, $locale),
                        ], 200
                    );
                } else {
                    return new JsonResponse(
                        [
                            'value'       => null,
                            'valueAmount' => null,
                            'message'     => $this->translator->trans('shop.promo_code.count_error', [], null, $locale),
                        ], 400
                    );
                }
            }
        }

        return new JsonResponse(
            [
                'value'       => null,
                'valueAmount' => null,
                'message'     => $this->translator->trans('shop.promo_code.error', [], null, $locale),
            ], 400
        );
    }

    /**
     * @param Request $request
     *
     * @Route("/request/price_promo", options={"expose"=true}, name="promo_price")
     *
     * @return JsonResponse
     * @throws \Doctrine\ORM\NonUniqueResultException
     * @throws \Exception
     */
    public
    function PricePromoAction(Request $request
    ) {
        $form = $this->createForm(CartType::class);
        $form->handleRequest($request);
        $cart       = $form->getData();
        $degressive = $this->calculDegressive->calcul($cart);

        if ($degressive) {
            return new JsonResponse($degressive, 200);
        }

        return new JsonResponse(null, 400);
    }

    /**
     * @Template("@CpCreationVitiCore/site/_formCodePrice.html.twig")
     * @Route(path="/request/check-code-price", name="price_code")
     * @param Request $request
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public
    function codePriceGroupAction(Request $request
    ) {
        $locale = $request->getLocale();
        $form   = $this->createForm(CheckCodePriceType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $data   = $form->getData();
            $code   = str_replace(' ', '', $data['code']);
            $result = $this->productPriceCodeRepository->findOneCode($code);
            if ($result) {
                $response = new RedirectResponse($this->router->generate('shop', ['_locale' => $locale]));
                $this->session->set("groupPrice", $result->getGroup()->getId()->toString());
                $this->session->set("groupByDefault", false);
                $this->session->set("codePrice", $result->getId()->toString());
                //$response->headers->setCookie(new Cookie('PRICE', $result->getId(), time() + (1 * 24 * 60 * 60), '/', null, false, false));
                $this->addFlash(
                    'success', $this->translator->trans(
                    'shop.form.partner.success', [
                    '%code%' => $code,
                ], null, $locale
                )
                );

                return $response;
            }

            $this->addFlash(
                'error', $this->translator->trans(
                'shop.form.partner.error_exist', [
                '%code%' => $code,
            ], null, $locale
            )
            );

            return $this->redirectToRoute('shop', ['_locale' => $locale]);
        }

        return [
            'form' => $form->createView(),
        ];
    }

    /**
     * @Route(path="/request/check-code-price/delete", name="price_code_delete")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public
    function deleteCodePriceGroupAction(Request $request
    ) {
        $locale   = $request->getLocale();
        $response = new RedirectResponse($this->router->generate('shop', ['_locale' => $locale]));
        $this->get('session')->set('cart', null);
        $this->session->set("groupPrice", null);
        $this->session->set("groupByDefault", true);
        $this->session->set("codePrice", null);

        return $response;
    }

    /**
     * @param Request $request
     * @Route("/request/etransactions/responseAt", name="etransactions_responseAt")
     *
     * @return Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public
    function EtransactionsResponseAt(Request $request
    ) {

        if ($request->request->get('Erreur')) {

            $code = $request->request->get('Erreur', null);

        } else {
            $code = $request->query->get('Erreur', null);
        }

        if ($request->request->get('Ref')) {

            $ref = $request->request->get('Ref', null);

        } else {
            $ref = $request->query->get('Ref', null);
        }

        if ($request->request->all()) {

            $response = $request->request->all();

        } else {
            $response = $request->query->all();
        }
        if (!$ref || !$code) {
            throw new BadRequestHttpException();
        }
        /** Accès au variant désactivé, si paiement effectué après la désactivation d'un variant  */
        $this->em->getFilters()->disable("soft_deletable");
        /** @var Cart $cart */
        $cart = $this->cartRepository->findOneBy(['token' => $ref]);
        if ($cart) {
            $checkout = $cart->getCartCheckout();
            $checkout->setResponse($response);
            if ($code === '00000') {
                $checkout->setPayedAt(new \DateTime('now'));
                $this->getDoctrine()->getManager()->persist($checkout);
                $this->getDoctrine()->getManager()->flush();
                $contact = $this->contactRepository->findOne();
                $this->mailer->sendOrder($contact, $cart);
            } else {
                $this->getDoctrine()->getManager()->persist($checkout);
                $this->getDoctrine()->getManager()->flush();
            }
        } else {
            /** @var Payment $payment */
            $payment = $this->paymentRepository->findOneBy(['slug' => $ref]);
            if ($payment) {
                if ($code === '00000') {

                    $payment->setResponse($response);
                    $payment->setPayedAt(new \DateTime('now'));
                    $this->mailer->sendPayment($payment);
                } else {
                    $payment->setResponse($response);
                }

                $this->getDoctrine()->getManager()->persist($payment);
                $this->getDoctrine()->getManager()->flush();
            }
        }

        return new Response('', 200);

    }

    /**
     * @param Request $request
     * @Route("/request/monetico/responseAt", name="monetico_responseAt")
     *
     * @return Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public
    function MoneticoResponseAt(Request $request
    ) {
        if ($request->request->get('code-retour')) {

            $code = $request->request->get('code-retour', null);

        } else {
            $code = $request->query->get('code-retour', null);
        }

        if ($request->request->get('reference')) {

            $ref = $request->request->get('reference', null);

        } else {
            $ref = $request->query->get('reference', null);
        }

        if ($request->request->all()) {

            $response = $request->request->all();

        } else {
            $response = $request->query->all();
        }

        if (!$ref || !$code) {
            throw new BadRequestHttpException();
        }

        /** Accès au variant désactivé, si paiement effectué après la désactivation d'un variant  */
        $this->em->getFilters()->disable("soft_deletable");
        /** @var Cart $cart */
        $cart = $this->cartRepository->findOneBy(['token' => $ref]);
        if ($cart) {
            $checkout = $cart->getCartCheckout();
            $checkout->setResponse($response);
            if ($code === 'payetest' || $code === 'paiement') {
                $checkout->setPayedAt(new \DateTime('now'));
                $this->getDoctrine()->getManager()->persist($checkout);
                $this->getDoctrine()->getManager()->flush();
                $contact = $this->contactRepository->findOne();
                $this->mailer->sendOrder($contact, $cart);
            } else {
                $this->getDoctrine()->getManager()->persist($checkout);
                $this->getDoctrine()->getManager()->flush();
            }

            return new Response('version=2'."\n".'cdr=0', 200);
        } else {
            /** @var Payment $payment */
            $payment = $this->paymentRepository->findOneBy(['slug' => $ref]);
            if ($payment) {
                if ($code === 'payetest' || $code === 'paiement') {
                    $payment->setPayedAt(new \DateTime('now'));
                    $payment->setResponse($response);
                    $this->mailer->sendPayment($payment);
                } else {
                    $payment->setResponse($response);
                }
                $this->getDoctrine()->getManager()->persist($payment);
                $this->getDoctrine()->getManager()->flush();

                return new Response('version=2'."\n".'cdr=0', 200);
            }
        }

        return new Response('version=2'."\n".'cdr=1'."\n", 200);


    }

    /**
     * @param Request $request
     * @Route("/request/sherlock/responseAt", name="sherlock_responseAt")
     *
     * @return Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function SherlockResponseAt(Request $request)
    {
        $message           = "message=".$request->request->get('DATA');
        $pathfile          = $this->sherlockFinder->getFileInfos("pathfile", "pathname");
        $path_bin_response = $this->sherlock_dir["sherlock_response_path"];
        $params            = "$path_bin_response pathfile=$pathfile $message";
        $result            = exec($params);
        $response          = explode("!", $result);
        $token             = $response[22];
        if ($this->sherlockPayment->valid($response)) {
            /** @var Cart $cart */
            $cart = $this->cartRepository->findOneBy(['token' => $token]);
            if ($cart) {
                $checkout = $cart->getCartCheckout();
                $checkout->setResponse($response);
                $checkout->setPayedAt(new \DateTime('now'));
                $this->em->persist($checkout);
                $this->em->flush();
                $contact = $this->contactRepository->findOne();
                $this->mailer->sendOrder($contact, $cart);

            } else {
                /** @var Payment $payment */
                $payment = $this->paymentRepository->findOneBy(['slug' => $token]);
                if ($payment) {
                    $payment->setResponse($response);
                    $payment->setPayedAt(new \DateTime('now'));
                    $this->em->persist($payment);
                    $this->em->flush();
                    $this->mailer->sendPayment($payment);
                }
            }
        } else {
            $cart = $this->cartRepository->findOneBy(['token' => $token]);
            if ($cart) {
                $checkout = $cart->getCartCheckout();
                $checkout->setResponse($response);
                $this->em->persist($checkout);
                $this->em->flush();
            } else {
                /** @var Payment $payment */
                $payment = $this->paymentRepository->findOneBy(['slug' => $token]);
                if ($payment) {
                    $payment->setResponse($response);
                    $this->em->persist($payment);
                    $this->em->flush();
                }
            }
        }

        return new Response('', 200);
    }

    /**
     * @param Request $request
     * @Route("/request/systempay/responseAt", name="systempay_responseAt")
     *
     * @return Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function SystemPayResponseAt(Request $request)
    {
        $response = $request->request->all();
        if ($response) {
            /** @var Cart $cart */
            $cart = $this->cartRepository->findOneBy(['token' => $response['vads_trans_id']]);
            if ($this->systempayPayment->valid($response)) {
                if ($cart) {
                    $checkout = $cart->getCartCheckout();
                    $checkout->setResponse($response);
                    $checkout->setPayedAt(new \DateTime('now'));
                    $this->em->persist($checkout);
                    $this->em->flush();
                    $contact = $this->contactRepository->findOne();
                    $this->mailer->sendOrder($contact, $cart);

                    return new Response('Order successfully updated');
                } else {
                    /** @var Payment $payment */
                    $payment = $this->paymentRepository->findOneBy(['slug' => $response['vads_trans_id']]);
                    if ($payment) {
                        $payment->setResponse($response);
                        $payment->setPayedAt(new \DateTime('now'));
                        $this->getDoctrine()->getManager()->persist($payment);
                        $this->getDoctrine()->getManager()->flush();
                        $this->mailer->sendPayment($payment);

                        return new Response('Order successfully updated');
                    }
                }

                return new Response('Data received but no cart associated');
            } else {
                if ($cart) {
                    $checkout = $cart->getCartCheckout();
                    $checkout->setResponse($response);
                    $this->em->persist($checkout);
                    $this->em->flush();
                } else {
                    /** @var Payment $payment */
                    $payment = $this->paymentRepository->findOneBy(['slug' => $response['vads_trans_id']]);
                    if ($payment) {
                        $payment->setResponse($response);
                        $this->getDoctrine()->getManager()->persist($payment);
                        $this->getDoctrine()->getManager()->flush();
                    }
                }

                return new Response('Payment refused');
            }
        }

        return new Response('POST is empty');
    }

    /**
     * @param Request $request
     * @Route("/request/sogecommerce/responseAt", name="sogecommerce_responseAt")
     *
     * @return Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function SogeCommerceResponseAt(Request $request)
    {
        $response = $request->request->all();
        if ($response) {
            /** @var Cart $cart */
            $cart = $this->cartRepository->findOneBy(['token' => $response['vads_trans_id']]);
            if ($this->sogeCommercePayment->valid($response)) {
                if ($cart) {
                    $checkout = $cart->getCartCheckout();
                    $checkout->setResponse($response);
                    $checkout->setPayedAt(new \DateTime('now'));
                    $this->em->persist($checkout);
                    $this->em->flush();
                    $contact = $this->contactRepository->findOne();
                    $this->mailer->sendOrder($contact, $cart);

                    return new Response('Order successfully updated');
                } else {
                    /** @var Payment $payment */
                    $payment = $this->paymentRepository->findOneBy(['slug' => $response['vads_trans_id']]);
                    if ($payment) {
                        $payment->setResponse($response);
                        $payment->setPayedAt(new \DateTime('now'));
                        $this->getDoctrine()->getManager()->persist($payment);
                        $this->getDoctrine()->getManager()->flush();
                        $this->mailer->sendPayment($payment);

                        return new Response('Order successfully updated');
                    }
                }

                return new Response('Data received but no cart associated');
            } else {
                if ($cart) {
                    $checkout = $cart->getCartCheckout();
                    $checkout->setResponse($response);
                    $this->em->persist($checkout);
                    $this->em->flush();
                } else {
                    /** @var Payment $payment */
                    $payment = $this->paymentRepository->findOneBy(['slug' => $response['vads_trans_id']]);
                    if ($payment) {
                        $payment->setResponse($response);
                        $this->getDoctrine()->getManager()->persist($payment);
                        $this->getDoctrine()->getManager()->flush();
                    }
                }


                return new Response('Payment refused');
            }
        }

        return new Response('POST is empty');
    }
}
