<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Command;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Client\ConnectCpCreationClient;
use CpCreation\VitiCore\Contact\Model\Contact;
use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use CpCreation\VitiCore\SocialNetwork\Model\SocialNetworkNew;
use CpCreation\VitiCore\SocialNetwork\Repository\SocialNetworkNewRepository;
use Doctrine\ORM\EntityManager;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;
use Symfony\Component\Finder\Finder;

class RefreshTokenInstagramCommand extends Command implements ContainerAwareInterface
{
    use ContainerAwareTrait;

    private $socialNetworkNewRepository;
    private $connectCpCreationClient;

    public function __construct(?string $name = null,
        SocialNetworkNewRepository $socialNetworkNewRepository,
        ConnectCpCreationClient $connectCpCreationClient
    ) {
        parent::__construct($name);
        $this->socialNetworkNewRepository = $socialNetworkNewRepository;
        $this->connectCpCreationClient    = $connectCpCreationClient;
    }

    protected function configure()
    {
        $this->setName('viti-core:refresh-token-instagram');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int|void
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $io = new SymfonyStyle($input, $output);
        /** @var SocialNetworkNew $socialNetwork */
        $socialNetwork = $this->socialNetworkNewRepository->findByLikeSocial('basic_instagram');
        $connect = $this->connectCpCreationClient->get('api/client_socials/'.$socialNetwork->getConnectId().'/refreshtoken');

        $io->comment('refresh Token Instagram Done !');

        return Command::SUCCESS;
    }
}
