<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Behavior\Impl;

use Doctrine\ORM\Mapping as ORM;
use CpCreation\VitiCore\Media\Model\Image as ModelImage;

trait Image
{
    /**
     * @ORM\OneToOne(targetEntity="CpCreation\VitiCore\Media\Model\Image", cascade={"persist", "remove"})
     * @ORM\JoinColumn(name="image_id", nullable=true, referencedColumnName="id", onDelete="SET NULL")
     * @var ModelImage
     */
    private $image;

    /**
     * @return ModelImage|null
     */
    public function getImage(): ?ModelImage
    {
        return $this->image;
    }

    /**
     * @param ModelImage|null $image
     */
    public function setImage(ModelImage $image = null)
    {
        if ($image->getPath() || $image->getFile()) {
            $this->image = $image;
        } else {
            $this->image = null;
        }
    }
}
