<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Repository;

use CpCreation\VitiCore\Repository\BaseRepository;
use CpCreation\VitiCore\Shop\Model\ShippingCounty;
use Doctrine\ORM\Query\Expr\Join;
use Doctrine\Persistence\ManagerRegistry;

class ShippingCountyRepository extends BaseRepository
{
    /**
     * ShippingCountyRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ShippingCounty::class);
    }

    /**
     * @param $department
     * @param $country
     * @return mixed
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findDepartmentByCountry($department, $country)
    {
        $qb = $this->createQueryBuilder('s')
                   ->innerJoin("s.zone", "z")
                   ->innerJoin("z.countries", 'c', Join::WITH, 'c.code = :country')
                   ->andWhere('s.code = :department')
                   ->setParameter('department', $department)
                   ->setParameter('country', $country)
                   ->getQuery()->getOneOrNullResult();


        return $qb;
    }

    public function findWithZoneNotNullQuery()
    {
        return $qb = $this->createQueryBuilder('s')
                          ->andWhere('s.zone IS NOT NULL')
                          ->orderBy('s.code', 'ASC');
    }
}
