<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model;

use CpCreation\VitiCore\Behavior\HasFile;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\File;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Knp\DoctrineBehaviors\Contract\Entity\TranslationInterface;
use Ramsey\Uuid\Uuid;
use CpCreation\VitiCore\Media\Model\File as ModelFile;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Context\ExecutionContextInterface;

/**
 * Class ShippingConfig
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Shop\Repository\ShippingConfigRepository")
 * @ORM\Table(name="shop_shipping_config")
 * @ORM\HasLifecycleCallbacks()
 */
class ShippingConfig implements HasFile, HasTimestamp, HasTranslatable
{
    use File, Timestamp, Translatable;

    /**
     * @Assert\Valid
     * @AcmeAssert\Translation()
     * @ORM\OneToMany(targetEntity="CpCreation\VitiCore\Shop\Model\Translation\ShippingConfigTranslation", mappedBy="translatable", cascade={"persist","remove","merge"}, indexBy="locale", orphanRemoval="true")
     *
     * @var TranslationInterface[]|Collection
     */
    protected $translations;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $marginGazoleAuto;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $marginAuto;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $marginClientAuto;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $marginManu;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $marginClientManu;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $tvaManu;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $marginBank;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $amountMarginBank;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $qtyEquivalencyBottle;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $amountMinVDManu;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $amountByBottleTTC;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $amountAutoByBottleTTC;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $amountMinVDAuto;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $qtyMinVDAuto;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $amountVDAuto;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $amountPercentVDAuto;

    /**
     * @Assert\NotBlank()
     * @ORM\Column(type="integer", nullable=false, options={"default"=0})
     *
     * @var integer
     */
    private $amountFixedBeforeMargeAuto = 0;

    /**
     * @Assert\NotBlank()
     * @ORM\Column(type="integer", nullable=false, options={"default"=0})
     *
     * @var integer
     */
    private $amountFixedAuto = 0;

    /**
     * @Assert\NotBlank()
     * @ORM\Column(type="integer", nullable=false, options={"default"=0})
     *
     * @var integer
     */
    private $amountFixedManu = 0;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var float | null
     */
    private $highMountainAmount;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer |null
     */
    private $amountFreeShipping;

    // force l'équivalence en Auto pour les type avec la prise en charge des frais de port Auto, si coché, le panier est rasnformé en équivalence bouteille
    // si il n'y a pas de correspondance en mode manuel de frais de port avec l'equivalence en Auto pour le type par défaut ( bouteille ) et transorme également tout en équivalence bouteille
    // si le type par defaut (bouteille ne trouve pas de correspondance dans la base de donnée )
    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $forceEquivalencyForAuto;

    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @var string | null
     */
    private $carrier;

    /**
     * @ORM\OneToOne(targetEntity="CpCreation\VitiCore\Media\Model\File", cascade={"persist", "remove"})
     * @var ModelFile
     */
    private $fileSup;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->forceEquivalencyForAuto = false;
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return float
     */
    public function getMarginAuto(): ?float
    {
        return $this->marginAuto;
    }

    /**
     * @return float
     */
    public function getMarginGazoleAuto(): ?float
    {
        return $this->marginGazoleAuto;
    }

    /**
     * @param float $marginGazoleAuto
     */
    public function setMarginGazoleAuto(?float $marginGazoleAuto): void
    {
        $this->marginGazoleAuto = $marginGazoleAuto;
    }

    /**
     * @param float $marginAuto
     */
    public function setMarginAuto(float $marginAuto = null)
    {
        $this->marginAuto = $marginAuto;
    }

    /**
     * @return float
     */
    public function getMarginClientAuto(): ?float
    {
        return $this->marginClientAuto;
    }

    /**
     * @param float $marginClientAuto
     */
    public function setMarginClientAuto(?float $marginClientAuto): void
    {
        $this->marginClientAuto = $marginClientAuto;
    }

    /**
     * @return float
     */
    public function getMarginManu(): ?float
    {
        return $this->marginManu;
    }

    /**
     * @param float $marginManu
     */
    public function setMarginManu(float $marginManu = null)
    {
        $this->marginManu = $marginManu;
    }

    /**
     * @return float|null
     */
    public function getMarginClientManu(): ?float
    {
        return $this->marginClientManu;
    }

    /**
     * @param float|null $marginClientManu
     */
    public function setMarginClientManu(?float $marginClientManu): void
    {
        $this->marginClientManu = $marginClientManu;
    }

    /**
     * @return float
     */
    public function getTvaManu(): ?float
    {
        return $this->tvaManu;
    }

    /**
     * @param float $tvaManu
     */
    public function setTvaManu(float $tvaManu= null)
    {
        $this->tvaManu = $tvaManu;
    }

    /**
     * @return float
     */
    public function getMarginBank(): ?float
    {
        return $this->marginBank;
    }

    /**
     * @param float $marginBank
     */
    public function setMarginBank(float $marginBank = null)
    {
        $this->marginBank = $marginBank;
    }

    /**
     * @return int|null
     */
    public function getAmountMarginBank(): ?int
    {
        return $this->amountMarginBank;
    }

    /**
     * @param int|null $amountMarginBank
     */
    public function setAmountMarginBank(?int $amountMarginBank): void
    {
        $this->amountMarginBank = $amountMarginBank;
    }

    /**
     * @return int
     */
    public function getQtyEquivalencyBottle(): ?int
    {
        return $this->qtyEquivalencyBottle;
    }

    /**
     * @param int $qtyEquivalencyBottle
     */
    public function setQtyEquivalencyBottle(int $qtyEquivalencyBottle = null)
    {
        $this->qtyEquivalencyBottle = $qtyEquivalencyBottle;
    }

    /**
     * @return int|null
     */
    public function getAmountMinVDManu(): ?int
    {
        return $this->amountMinVDManu;
    }

    /**
     * @param int|null $amountMinVDManu
     */
    public function setAmountMinVDManu(?int $amountMinVDManu): void
    {
        $this->amountMinVDManu = $amountMinVDManu;
    }

    /**
     * @return int|null
     */
    public function getAmountByBottleTTC(): ?int
    {
        return $this->amountByBottleTTC;
    }

    /**
     * @param int|null $amountByBottleTTC
     */
    public function setAmountByBottleTTC(?int $amountByBottleTTC): void
    {
        $this->amountByBottleTTC = $amountByBottleTTC;
    }

    /**
     * @return int|null
     */
    public function getAmountAutoByBottleTTC(): ?int
    {
        return $this->amountAutoByBottleTTC;
    }

    /**
     * @param int|null $amountAutoByBottleTTC
     */
    public function setAmountAutoByBottleTTC(?int $amountAutoByBottleTTC): void
    {
        $this->amountAutoByBottleTTC = $amountAutoByBottleTTC;
    }
    
    /**
     * @return int | null
     */
    public function getAmountMinVDAuto(): ?int
    {
        return $this->amountMinVDAuto;
    }

    /**
     * @param int $amountMinVDAuto | null
     */
    public function setAmountMinVDAuto(?int $amountMinVDAuto): void
    {
        $this->amountMinVDAuto = $amountMinVDAuto;
    }

    /**
     * @return int|null
     */
    public function getQtyMinVDAuto(): ?int
    {
        return $this->qtyMinVDAuto;
    }

    /**
     * @param int|null $qtyMinVDAuto
     */
    public function setQtyMinVDAuto(?int $qtyMinVDAuto): void
    {
        $this->qtyMinVDAuto = $qtyMinVDAuto;
    }

    /**
     * @return int|null
     */
    public function getAmountVDAuto(): ?int
    {
        return $this->amountVDAuto;
    }

    /**
     * @param int|null $amountVDAuto
     */
    public function setAmountVDAuto(?int $amountVDAuto): void
    {
        $this->amountVDAuto = $amountVDAuto;
    }

    /**
     * @return float|null
     */
    public function getAmountPercentVDAuto(): ?float
    {
        return $this->amountPercentVDAuto;
    }

    /**
     * @param float|null $amountPercentVDAuto
     */
    public function setAmountPercentVDAuto(?float $amountPercentVDAuto): void
    {
        $this->amountPercentVDAuto = $amountPercentVDAuto;
    }


    /**
     * @return int
     */
    public function getAmountFixedBeforeMargeAuto(): ?int
    {
        return $this->amountFixedBeforeMargeAuto;
    }

    /**
     * @param int $amountFixedBeforeMargeAuto
     */
    public function setAmountFixedBeforeMargeAuto(?int $amountFixedBeforeMargeAuto): void
    {
        $this->amountFixedBeforeMargeAuto = $amountFixedBeforeMargeAuto;
    }

    /**
     * @return int
     */
    public function getAmountFixedAuto(): ?int
    {
        return $this->amountFixedAuto;
    }

    /**
     * @param int $amountFixedAuto
     */
    public function setAmountFixedAuto(int $amountFixedAuto = null)
    {
        $this->amountFixedAuto = $amountFixedAuto;
    }

    /**
     * @return int
     */
    public function getAmountFixedManu(): ?int
    {
        return $this->amountFixedManu;
    }

    /**
     * @param int $amountFixedManu
     */
    public function setAmountFixedManu(int $amountFixedManu = null)
    {
        $this->amountFixedManu = $amountFixedManu;
    }

    /**
     * @return float
     */
    public function getHighMountainAmount(): ?float
    {
        return $this->highMountainAmount;
    }

    /**
     * @param float $highMountainAmount
     */
    public function setHighMountainAmount(float $highMountainAmount = null)
    {
        $this->highMountainAmount = $highMountainAmount;
    }

    /**
     * @return int
     */
    public function getAmountFreeShipping(): ?int
    {
        return $this->amountFreeShipping;
    }

    /**
     * @param int $amountFreeShipping
     */
    public function setAmountFreeShipping(int $amountFreeShipping = null)
    {
        $this->amountFreeShipping = $amountFreeShipping;
    }

    /**
     * @return bool
     */
    public function isForceEquivalencyForAuto(): bool
    {
        return $this->forceEquivalencyForAuto;
    }

    /**
     * @param bool $forceEquivalencyForAuto
     */
    public function setForceEquivalencyForAuto(bool $forceEquivalencyForAuto): void
    {
        $this->forceEquivalencyForAuto = $forceEquivalencyForAuto;
    }

    /**
     * @return string
     */
    public function getCarrier(): ?string
    {
        return $this->carrier;
    }

    /**
     * @param string $carrier
     */
    public function setCarrier(?string $carrier)
    {
        $this->carrier = $carrier;
    }

    /**
     * @return ModelFile|null
     */
    public function getFileSup(): ?ModelFile
    {
        return $this->fileSup;
    }

    /**
     * @param ModelFile $fileSup
     */
    public function setFileSup(ModelFile $fileSup = null)
    {
        $this->fileSup = $fileSup;
    }

}
