<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Knp\DoctrineBehaviors\Contract\Entity\TranslationInterface;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class ProductTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="product_product_translation")
 */
class ProductTranslation implements TranslationInterface
{
    use Translation;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;
    
    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $header;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $name;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $quality;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $otherText1;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string | null
     */
    private $ribbonCustom;

    /**
     * @ORM\Column(type="text")
     * @Gedmo\Slug(fields={"name","quality"})
     *
     * @var string
     */
    private $slug;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $description;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $introText;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $infoShop;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string | null
     */
    private $dosage;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string | null
     */
    private $tasting;

    /**
     * @ORM\Column(type="json", nullable=true)
     *
     * @var array
     */
    private $assemblages;

    /**
     * @ORM\Column(type="json", nullable=true)
     *
     * @var array
     */
    private $winemaking;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string | null
     */
    private $selectVariant;

    public function __construct()
    {
        $this->id       = Uuid::uuid4();
        $this->assemblages = [];
        $this->winemaking  = [];
    }
    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }
    
    /**
     * @return string
     */
    public function getHeader(): ?string
    {
        return $this->header;
    }

    /**
     * @param string $header
     */
    public function setHeader(string $header = null)
    {
        $this->header = $header;
    }

    /**
     * @return string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name = null): void
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getOtherText1(): ?string
    {
        return $this->otherText1;
    }

    /**
     * @param string $otherText1
     */
    public function setOtherText1(string $otherText1 = null)
    {
        $this->otherText1 = $otherText1;
    }

    /**
     * @return null|string
     */
    public function getRibbonCustom(): ?string
    {
        return $this->ribbonCustom;
    }

    /**
     * @param null|string $ribbonCustom
     */
    public function setRibbonCustom(?string $ribbonCustom): void
    {
        $this->ribbonCustom = $ribbonCustom;
    }

    /**
     * @return string
     */
    public function getQuality(): ?string
    {
        return $this->quality;
    }

    /**
     * @param string $quality
     */
    public function setQuality(string $quality = null): void
    {
        $this->quality = $quality;
    }

    /**
     * @return string
     */
    public function getSlug(): ?string
    {
        return $this->slug;
    }

    /**
     * @param string $slug
     */
    public function setSlug(string $slug): void
    {
        $this->slug = $slug;
    }

    /**
     * @return string
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription(string $description = null): void
    {
        $this->description = $description;
    }

    /**
     * @return string
     */
    public function getIntroText(): ?string
    {
        return $this->introText;
    }

    /**
     * @param string $introText
     */
    public function setIntroText(string $introText = null): void
    {
        $this->introText = $introText;
    }

    /**
     * @return string
     */
    public function getInfoShop(): ?string
    {
        return $this->infoShop;
    }

    /**
     * @param string $infoShop
     */
    public function setInfoShop(string $infoShop = null): void
    {
        $this->infoShop = $infoShop;
    }

    /**
     * @return string
     */
    public function getDosage(): ?string
    {
        return $this->dosage;
    }

    /**
     * @param string $dosage
     */
    public function setDosage(?string $dosage): void
    {
        $this->dosage = $dosage;
    }

    /**
     * @return string|null
     */
    public function getTasting(): ?string
    {
        return $this->tasting;
    }

    /**
     * @param string $tasting|null
     */
    public function setTasting(?string $tasting): void
    {
        $this->tasting = $tasting;
    }

    /**
     * @return array|null
     */
    public function getAssemblages(): ?array
    {
        return $this->assemblages;
    }

    /**
     * @param array $assemblages
     */
    public function setAssemblages(?array $assemblages)
    {
        $this->assemblages = $assemblages;
    }

    /**
     * @return array|null
     */
    public function getWinemaking(): ?array
    {
        return $this->winemaking;
    }

    /**
     * @param array $winemaking
     */
    public function setWinemaking(?array $winemaking): void
    {
        $this->winemaking = $winemaking;
    }

    /**
     * @return string|null
     */
    public function getSelectVariant(): ?string
    {
        return $this->selectVariant;
    }

    /**
     * @param string|null $selectVariant
     */
    public function setSelectVariant(?string $selectVariant): void
    {
        $this->selectVariant = $selectVariant;
    }

    public function getFullName()
    {
        $fullName = '';
        if ($this->getHeader()) {
            $fullName = $this->getHeader().' ';
        }

        $fullName .= $this->getName();

        if ($this->getQuality()) {
            $fullName .= ' '.$this->getQuality();
        }

        return $fullName;
    }
}
