<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Service;

use Symfony\Component\Finder\Finder;

class SherlockService
{
    private $sherlockDir;

    public function __construct($sherlockDir)
    {
        $this->sherlockDir = $sherlockDir;
    }

    /**
     * @param null $specific_dir
     * @return mixed
     */
    public function getSherlockDir($specific_dir = null)
    {
        if ($specific_dir != null) {
            return $this->sherlockDir[$specific_dir];
        } else {
            return $this->sherlockDir['sherlock_config_directory_path'];
        }
    }

    /**
     * @param array|null  $fileNamesList
     * @param string|null $directory
     * @return array|mixed|\Symfony\Component\Finder\SplFileInfo
     */
    public function getFiles(array $fileNamesList = null, string $directory = null)
    {
        $data   = [];
        $finder = new Finder();

        if ($directory != null) {
            $dir = $this->sherlockDir[$directory];
        } else {
            $dir = $this->sherlockDir['sherlock_config_directory_path'];
        }

        if ($fileNamesList != null && count($fileNamesList) != 0) {
            $finder->files()->name($fileNamesList)->in($dir);
        } else {
            $finder->files()->in($dir);
        }

        if ($finder->hasResults()) {
            foreach ($finder as $file) {
                if ($fileNamesList != null && count($fileNamesList) === 1) {
                    $data = $file;
                } else {
                    $data[$file->getFilename()] = $file;
                }
            }
        }

        return $data;
    }

    /**
     * @param string $filename
     * @param string $fileMethod
     * @return string
     */
    public function getFileInfos(string $filename, string $fileMethod)
    {
        $file    = $this->getFiles([$filename]);
        $methods = [
            'path',
            'filename',
            'pathname',
        ];

        foreach ($methods as $method) {
            if ($method == $fileMethod) {
                switch ($method) {
                    case 'path';
                        return $file->getPath();
                        break;
                    case 'filename';
                        return $file->getFilename();
                        break;
                    case 'pathname';
                        return $file->getPathname();
                }
            }
        }
    }

    /**
     * @param string $filename
     * @param null   $directory
     * @return false|string|void
     */
    public function getFileContent(string $filename, $directory = null)
    {
        if ($filename != null) {
            if ($directory != null) {
                return file_get_contents($this->getSherlockDir($directory).$this->getCompleteFileName($filename, $directory));
            }

            return file_get_contents($this->getSherlockDir().$this->getCompleteFileName($filename));
        }
    }

    /**
     * @param string $key_word
     * @param null   $directory
     * @return mixed
     */
    public function getCompleteFileName(string $key_word, $directory = null)
    {
        if ($key_word != null) {
            if ($directory != null) {
                $files = $this->getFiles(null, $directory);
            } else {
                $files = $this->getFiles();
            }
            foreach ($files as $file) {
                if (strpos($file->getFilename(), $key_word) !== false) {
                    return $file->getFilename();
                }
            }
        }
    }
}
