(function ($) {
    'use strict';
    $('[data-toggle="tooltip"]').tooltip();
    $('.select2').select2();
    $('.datetimepicker').datetimepicker({
        locale: 'fr',
        format: 'YYYY-MM-DD HH:mm'
    });
    $('.confirm-deletable').on('click', function (e) {
        $("#btnDeletable").attr('href', $(this).attr('href'));
        $("#confirmDeletable .modal-body").text($(this).attr('data-title'));
        $("#confirmDeletable").modal('show');
        e.preventDefault();

        return false;
    });

    window.setTimeout(function () {
        $(".alert alert-success").fadeTo(500, 0).slideUp(500, function () {
            $(this).remove();
        });
    }, 4000);

    jQuery('.datetimepicker').datetimepicker({
        locale: 'fr',
        format: 'YYYY-MM-DD HH:mm'
    });
    $('.trumbowyg').trumbowyg({
        lang: 'fr',
        semantic: false,
        removeformatPasted: true,
        svgPath: '/bundles/cpcreationviticore/fonts/icons.svg',
        btns: [
            ['viewHTML'],
            ['undo', 'redo'], // Only supported in Blink browsers
            ['formatting'],
            ['strong', 'em', 'del'],
            ['superscript', 'subscript'],
            ['link'],
            ['removeformat'],
            ['fullscreen']
        ]

    });

    $('.select2-tag').select2({
        tags: true,
        tokenSeparators: [",", " "],
        createTag: function (tag) {
            return {
                id: tag.term,
                text: tag.term,
                // add indicator:
                isNew: true
            };
        },
    }).on("select2-tag:select", function (e) {
        if (e.params.data.isNew) {
            jQuery(this).find('[value="' + e.params.data.id + '"]').replaceWith('<option selected value="' + e.params.data.code + '">' + e.params.data.code + '</option>');
        }
    });

    $(document).ready(function () {
        $('.dataTable').DataTable({
            stateSave: true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.20/i18n/French.json"
            }
        });
    });

    $('.remove-media').on('click', function (e) {
        e.preventDefault();
        let id = $(this).data('id');
        $.ajax({
            type: 'GET',
            url: Routing.generate('media_delete', {id: id}),
            dataType: 'json',
            success: function (result) {
                $(".media-file[data-id='" + id + "']").remove();

                return;
            },
            error: function () {


                return;
            },
        });
        return false;
    });
    if ($('.insta-photo').length)
    {
        let username = $('.insta-photo').data('username');
        $.get("https://www.instagram.com/"+username+"/?__a=1")
            .done(function(data) {
                // getting the url
                var photoURL = data["graphql"]["user"]["profile_pic_url_hd"];
                // update img element
                $(".insta-photo").attr("src",photoURL)
            })
    }
   
})($);
