<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site;


use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\EventListener\AddErrorMessageValidationListener;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;

class ContactType extends AbstractType
{

    /** @var AddErrorMessageValidationListener $addErrorMessageValidationListener */
    private $addErrorMessageValidationListener;

    public function __construct(AddErrorMessageValidationListener $addErrorMessageValidationListener)
    {
        $this->addErrorMessageValidationListener = $addErrorMessageValidationListener;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $builder
            ->add('lastname', TextType::class, [
                'required'    => true,
                'label'       => false,
                'attr'        => ['placeholder' => 'contact.form.name', 'autocomplete' => 'name'],
                'constraints' => [new NotBlank()],
            ])
            ->add('phone', TextType::class, [
                'required'    => true,
                'label'       => false,
                'attr'        => ['placeholder' => 'contact.form.phone', 'autocomplete' => 'phone'],
                'constraints' => [new NotBlank()],
            ])
            ->add('email', EmailType::class, [
                'required'    => true,
                'label'       => false,
                'attr'        => ['placeholder' => 'contact.form.email', 'autocomplete' => 'email'],
                'constraints' => [new NotBlank()],
            ])
            ->add('message', TextareaType::class, [
                'required'    => true,
                'label'       => false,
                'attr'        => ['placeholder' => 'contact.form.message', 'rows' => 8],
                'constraints' => [new NotBlank()],
            ])
            ->add(
                'g_recaptcha_response', RecaptchaType::class
            )
        ;

        $builder->addEventSubscriber($this->addErrorMessageValidationListener);
    }
}
