<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site;

use A2lix\TranslationFormBundle\Form\Type\TranslatedEntityType;
use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Cart\Model\CartItem;
use CpCreation\VitiCore\Cart\Repository\PromoRepository;
use CpCreation\VitiCore\Product\Model\ProductPriceCode;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Shop\Model\DeliveryMethod;
use CpCreation\VitiCore\Shop\Repository\DeliveryMethodRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CartType extends AbstractType
{
    private $requestStack;
    private $groupId;
    private $promoRepository;

    public function __construct(RequestStack $requestStack,
        PromoRepository $promoRepository,
        SessionInterface $session
    ) {
        $this->requestStack    = $requestStack;
        $this->promoRepository = $promoRepository;
        $this->groupId         = $session->get('groupPrice');
    }

    public
    function buildForm(FormBuilderInterface $builder,
        array $options
    ) {
        $builder
            ->add(
                'items', CollectionType::class, [
                    'entry_type'    => CartItemType::class,
                    'label'         => false,
                    'allow_add'     => true,
                    'allow_delete'  => true,
                    'prototype'     => true,
                    'by_reference'  => false,
                    'entry_options' => [
                        'data_class' => CartItem::class,
                        'label'      => false,
                    ],

                ]
            )
            ->add(
                'invoiceAddress', InvoiceAddressType::class, [
                    'label'    => false,
                    'required' => true,
                ]
            )
            ->add(
                'deliveryAddress', DeliveryAddressType::class, [
                    'label'    => false,
                    'required' => true,
                ]
            )
            ->add(
                'comment', TextareaType::class, [
                    'label'    => 'shop.form.comment',
                    'attr'     => ['rows' => '5'],
                    'required' => false,
                ]
            )
            ->add(
                'cartCheckout', CartCheckoutType::class, [
                    'label' => false,
                ]
            )
            ->add(
                'deliveryMethod', TranslatedEntityType::class, [
                    'class'                => DeliveryMethod::class,
                    'label'                => false,
                    'placeholder'          => false,
                    'multiple'             => false,
                    'expanded'             => true,
                    'required'             => false,
                    'query_builder'        => function (DeliveryMethodRepository $er) {
                        return $er->findPublishQueryBuilder($this->groupId);
                    },
                    'translation_property' => 'name',
                ]
            )
            ->add(
                'g_recaptcha_response', RecaptchaType::class
            )
            ->addEventListener(
                FormEvents::PRE_SET_DATA,
                [$this, 'onPreSetData']
            );

    }

    public
    function onPreSetData(FormEvent $event
    ) {
        $form   = $event->getForm();
        $promos = $this->promoRepository->findPromoActiv();
        if ($promos) {
            $form->add(
                'promo', TextType::class, [
                    'required' => false,
                    'attr'     =>
                        [
                            'class' => 'promo',
                        ],
                    'label'    => false,
                ]
            );

        }
    }

    public
    function configureOptions(OptionsResolver $resolver
    ) {
        $resolver->setDefaults(
            [
                "data_class" => Cart::class,
            ]
        );
    }
}
