<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\News\Model\NewsImage;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class NewsImageType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'image', ImageType::class, [
                    'label'    => false,
                    'required' => true,
                ]
            )
            ->add(
                'position', IntegerType::class, [
                    'label'    => 'position',
                    'attr' => [
                        'class' => 'position-form'
                    ],
                    'required' => false,
                ]
            )
            ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => NewsImage::class,
            ]
        );
    }
}
