<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\DataTransformer;

use Symfony\Component\Form\DataTransformerInterface;

class TransformDateAtToIntAdditional implements DataTransformerInterface
{
    public function transform($value)
    {
        if ($value)
        {
            if (strlen($value) < 4)
            {
                $month = '0'.substr($value,0,1);
                $day = substr($value,1,2);
            }else{
                $month = substr($value,0,2);
                $day = substr($value,2,2);
            }
            $date = $day.'-'.$month.'-'.date('Y');

            return new \DateTime($date);
        }

        $date = '31-12-'.date('Y');

        return new \DateTime($date);
    }

    public function reverseTransform($value)
    {

        if ($value)
        {
            return date("nd", $value->getTimestamp());
        }

        return "1231";
    }
}
