<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Cart\Model\CartCheckout;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class CartCheckoutShippingType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('colissimoCarrier', CheckboxType::class, ['label' => 'Envoyer par Colissimo', 'required' => false])
            ->add('colissimoCode', TextType::class, ['label' => 'Code suivi Colissimo (si disponible)', 'required' => false])
            ->add('privateCarrier', CheckboxType::class, ['label' => 'Envoyer par transporteur Privé', 'required' => false])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => CartCheckout::class,
            ]
        );
    }
}
