<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\LocaleType;
use CpCreation\VitiCore\Locale\Model\Locale;
use CpCreation\VitiCore\Locale\Repository\LocaleRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class LocaleController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/langues")
 */
class LocaleController extends AbstractController
{
    private $localeRepository;

    public function __construct(LocaleRepository $localeRepository)
    {
        $this->localeRepository = $localeRepository;
    }

    /**
     * @route("", name="admin_locale")
     * @Template("@CpCreationVitiCore/admin/locale/index.html.twig")
     */
    public function indexAction()
    {
        $locales = $this->localeRepository->findBy([], ['name' => 'ASC']);

        return [
            "items" => $locales,
        ];
    }

    /**
     * @param Request $request
     * @Route("/new", name="admin_locale_new")
     * @Template("@CpCreationVitiCore/admin/locale/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(LocaleType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var Locale $data */
            $data = $form->getData();
            $this->localeRepository->save($data);
            $this->addFlash('alert-success', 'La langue '.$data->getName().' a été ajouté avec succès');

            return $this->redirectToRoute('admin_locale');
        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param Locale $locale
     * @param Request $request
     * @Route("/{id}/edit", name="admin_locale_edit")
     * @Template("@CpCreationVitiCore/admin/locale/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(Locale $locale, Request $request)
    {
        $form = $this->createForm(LocaleType::class, $locale);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var Locale $data */
            $data = $form->getData();
            $this->localeRepository->save($data);
            $this->addFlash('alert-success', 'La langue '.$locale->getName().' a été modifié avec succès');

            return $this->redirectToRoute('admin_locale');
        }

        return [
            "item" => $locale,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param Locale $locale
     * @Route("/{id}/moveUp", name="admin_locale_move_up")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function moveUpAction(Locale $locale)
    {
        $locale->setPosition($locale->getPosition() - 1);
        $this->localeRepository->save($locale);
        $this->addFlash('alert-success', 'La locale '.$locale->getName().' a été remonté.');

        return $this->redirectToRoute('admin_locale');
    }

    /**
     * @param Locale $locale
     * @Route("/{id}/moveDown", name="admin_locale_move_down")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function moveDownAction(Locale $locale)
    {
        $locale->setPosition($locale->getPosition() + 1);
        $this->localeRepository->save($locale);
        $this->addFlash('alert-success', 'La locale '.$locale->getName().' a été descendu.');

        return $this->redirectToRoute('admin_locale');
    }
    
    /**
     * @param Locale $locale
     * @Route("/{id}/delete", name="admin_locale_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(Locale $locale)
    {
        $this->localeRepository->delete($locale);
        $this->addFlash('alert-success', 'La locale '.$locale->getName().' a été supprimé avec succès.');

        return $this->redirectToRoute('admin_locale');
    }
}