<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Behavior\Impl;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\HasLifecycleCallbacks()
 */
trait Timestamp
{
    /**
     * @ORM\Column(type="datetime")
     *
     * @var \DateTimeInterface
     */
    private $createdAt;

    /**
     * @ORM\Column(type="datetime")
     *
     * @var \DateTimeInterface
     */
    private $updatedAt;

    public function getCreatedAt(): \DateTimeInterface
    {
        return $this->createdAt;
    }

    public function getUpdatedAt(): \DateTimeInterface
    {
        return $this->updatedAt;
    }

    /**
     * @param \DateTimeInterface $dateTime
     */
    public function setUpdatedAt(\DateTimeInterface $dateTime)
    {
        $this->updatedAt = $dateTime;
    }

    /**
     * @ORM\PrePersist()
     */
    public function generateTimestampsAtCreation()
    {
        $this->createdAt = new \DateTimeImmutable();
        $this->updatedAt = new \DateTimeImmutable();
    }

    /**
     * @ORM\PreUpdate()
     */
    public function updateTimestampsAtUpdate()
    {
        $this->updatedAt = new \DateTimeImmutable();
    }
}