<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model;

use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;

/**
 * Class ShopConfig
 *
 * @ORM\Table(name="shop_shop_config")
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Shop\Repository\ShopConfigRepository")
 */
class ShopConfig implements HasTimestamp
{
    use Timestamp;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $viewCategory;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $hidePriceDefault;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $enableAwardShop;

    public function __construct()
    {
        $this->id               = Uuid::uuid4();
        $this->viewCategory     = 1;
        $this->hidePriceDefault = 0;
        $this->enableAwardShop  = false;
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @return bool
     */
    public function isViewCategory(): bool
    {
        return $this->viewCategory;
    }

    /**
     * @param bool $viewCategory
     */
    public function setViewCategory(bool $viewCategory): void
    {
        $this->viewCategory = $viewCategory;
    }

    /**
     * @return bool
     */
    public function isHidePriceDefault(): bool
    {
        return $this->hidePriceDefault;
    }

    /**
     * @param bool $hidePriceDefault
     */
    public function setHidePriceDefault(bool $hidePriceDefault): void
    {
        $this->hidePriceDefault = $hidePriceDefault;
    }

    /**
     * @return bool
     */
    public function isEnableAwardShop(): bool
    {
        return $this->enableAwardShop;
    }

    /**
     * @param bool $enableAwardShop
     */
    public function setEnableAwardShop(bool $enableAwardShop): void
    {
        $this->enableAwardShop = $enableAwardShop;
    }
}
