<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model;

use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ShippingCounty
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Shop\Repository\ShippingCountyRepository")
 * @ORM\Table(name="shop_shipping_county")
 * @ORM\HasLifecycleCallbacks()
 */
class ShippingCounty
{
    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $code;

    /**
     * @ORM\ManyToOne(targetEntity="ShippingZone", inversedBy="counties")
     * @ORM\JoinColumn(name="zone_id", referencedColumnName="id")
     *
     * @var ShippingZone
     */
    private $zone;

    public function __construct()
    {
        $this->id   = Uuid::uuid4();
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode(string $code): void
    {
        $this->code = $code;
    }

    /**
     * @return ShippingZone
     */
    public function getZone(): ShippingZone
    {
        return $this->zone;
    }

    /**
     * @param ShippingZone $zone
     */
    public function setZone(ShippingZone $zone = null): void
    {
        $this->zone = $zone;
    }
}
