<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model;

use CpCreation\VitiCore\Behavior\HasFile;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\File;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use CpCreation\VitiCore\Media\Model\File as ModelFile;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ShippingConfig
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Shop\Repository\ShippingConfigRepository")
 * @ORM\Table(name="shop_shipping_config")
 * @ORM\HasLifecycleCallbacks()
 */
class ShippingConfig implements HasFile, HasTimestamp, HasTranslatable
{
    use File, Timestamp, Translatable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $marginGazoleAuto;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $marginAuto;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $marginClientAuto;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $marginManu;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $marginClientManu;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $tvaManu;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $marginBank;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $amountMarginBank;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $qtyEquivalencyBottle;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $amountMinVDManu;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $amountMinVDAuto;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=4, nullable=true)
     *
     * @var float | null
     */
    private $amountPercentVDAuto;

    /**
     * @Assert\NotBlank()
     * @ORM\Column(type="integer", nullable=false, options={"default"=0})
     *
     * @var integer
     */
    private $amountFixedBeforeMargeAuto = 0;

    /**
     * @Assert\NotBlank()
     * @ORM\Column(type="integer", nullable=false, options={"default"=0})
     *
     * @var integer
     */
    private $amountFixedAuto = 0;

    /**
     * @Assert\NotBlank()
     * @ORM\Column(type="integer", nullable=false, options={"default"=0})
     *
     * @var integer
     */
    private $amountFixedManu = 0;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var float | null
     */
    private $highMountainAmount;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer | null
     */
    private $amountFreeShipping;

    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @var string | null
     */
    private $carrier;

    /**
     * @ORM\OneToOne(targetEntity="CpCreation\VitiCore\Media\Model\File", cascade={"persist", "remove"})
     * @var ModelFile
     */
    private $fileSup;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @return float
     */
    public function getMarginAuto(): ?float
    {
        return $this->marginAuto;
    }

    /**
     * @return float
     */
    public function getMarginGazoleAuto(): ?float
    {
        return $this->marginGazoleAuto;
    }

    /**
     * @param float $marginGazoleAuto
     */
    public function setMarginGazoleAuto(?float $marginGazoleAuto): void
    {
        $this->marginGazoleAuto = $marginGazoleAuto;
    }

    /**
     * @param float $marginAuto
     */
    public function setMarginAuto(float $marginAuto = null)
    {
        $this->marginAuto = $marginAuto;
    }

    /**
     * @return float
     */
    public function getMarginClientAuto(): ?float
    {
        return $this->marginClientAuto;
    }

    /**
     * @param float $marginClientAuto
     */
    public function setMarginClientAuto(?float $marginClientAuto): void
    {
        $this->marginClientAuto = $marginClientAuto;
    }

    /**
     * @return float
     */
    public function getMarginManu(): ?float
    {
        return $this->marginManu;
    }

    /**
     * @param float $marginManu
     */
    public function setMarginManu(float $marginManu = null)
    {
        $this->marginManu = $marginManu;
    }

    /**
     * @return float|null
     */
    public function getMarginClientManu(): ?float
    {
        return $this->marginClientManu;
    }

    /**
     * @param float|null $marginClientManu
     */
    public function setMarginClientManu(?float $marginClientManu): void
    {
        $this->marginClientManu = $marginClientManu;
    }

    /**
     * @return float
     */
    public function getTvaManu(): ?float
    {
        return $this->tvaManu;
    }

    /**
     * @param float $tvaManu
     */
    public function setTvaManu(float $tvaManu= null)
    {
        $this->tvaManu = $tvaManu;
    }

    /**
     * @return float
     */
    public function getMarginBank(): ?float
    {
        return $this->marginBank;
    }

    /**
     * @param float $marginBank
     */
    public function setMarginBank(float $marginBank = null)
    {
        $this->marginBank = $marginBank;
    }

    /**
     * @return int|null
     */
    public function getAmountMarginBank(): ?int
    {
        return $this->amountMarginBank;
    }

    /**
     * @param int|null $amountMarginBank
     */
    public function setAmountMarginBank(?int $amountMarginBank): void
    {
        $this->amountMarginBank = $amountMarginBank;
    }

    /**
     * @return int
     */
    public function getQtyEquivalencyBottle(): ?int
    {
        return $this->qtyEquivalencyBottle;
    }

    /**
     * @param int $qtyEquivalencyBottle
     */
    public function setQtyEquivalencyBottle(int $qtyEquivalencyBottle = null)
    {
        $this->qtyEquivalencyBottle = $qtyEquivalencyBottle;
    }

    /**
     * @return int|null
     */
    public function getAmountMinVDManu(): ?int
    {
        return $this->amountMinVDManu;
    }

    /**
     * @param int|null $amountMinVDManu
     */
    public function setAmountMinVDManu(?int $amountMinVDManu): void
    {
        $this->amountMinVDManu = $amountMinVDManu;
    }

    /**
     * @return int | null
     */
    public function getAmountMinVDAuto(): ?int
    {
        return $this->amountMinVDAuto;
    }

    /**
     * @param int $amountMinVDAuto | null
     */
    public function setAmountMinVDAuto(?int $amountMinVDAuto): void
    {
        $this->amountMinVDAuto = $amountMinVDAuto;
    }

    /**
     * @return float|null
     */
    public function getAmountPercentVDAuto(): ?float
    {
        return $this->amountPercentVDAuto;
    }

    /**
     * @param float|null $amountPercentVDAuto
     */
    public function setAmountPercentVDAuto(?float $amountPercentVDAuto): void
    {
        $this->amountPercentVDAuto = $amountPercentVDAuto;
    }


    /**
     * @return int
     */
    public function getAmountFixedBeforeMargeAuto(): ?int
    {
        return $this->amountFixedBeforeMargeAuto;
    }

    /**
     * @param int $amountFixedBeforeMargeAuto
     */
    public function setAmountFixedBeforeMargeAuto(?int $amountFixedBeforeMargeAuto): void
    {
        $this->amountFixedBeforeMargeAuto = $amountFixedBeforeMargeAuto;
    }

    /**
     * @return int
     */
    public function getAmountFixedAuto(): ?int
    {
        return $this->amountFixedAuto;
    }

    /**
     * @param int $amountFixedAuto
     */
    public function setAmountFixedAuto(int $amountFixedAuto = null)
    {
        $this->amountFixedAuto = $amountFixedAuto;
    }

    /**
     * @return int
     */
    public function getAmountFixedManu(): ?int
    {
        return $this->amountFixedManu;
    }

    /**
     * @param int $amountFixedManu
     */
    public function setAmountFixedManu(int $amountFixedManu = null)
    {
        $this->amountFixedManu = $amountFixedManu;
    }

    /**
     * @return float
     */
    public function getHighMountainAmount(): ?float
    {
        return $this->highMountainAmount;
    }

    /**
     * @param float $highMountainAmount
     */
    public function setHighMountainAmount(float $highMountainAmount = null)
    {
        $this->highMountainAmount = $highMountainAmount;
    }

    /**
     * @return int
     */
    public function getAmountFreeShipping(): ?int
    {
        return $this->amountFreeShipping;
    }

    /**
     * @param int $amountFreeShipping
     */
    public function setAmountFreeShipping(int $amountFreeShipping = null)
    {
        $this->amountFreeShipping = $amountFreeShipping;
    }

    /**
     * @return string
     */
    public function getCarrier(): ?string
    {
        return $this->carrier;
    }

    /**
     * @param string $carrier
     */
    public function setCarrier(?string $carrier)
    {
        $this->carrier = $carrier;
    }

    /**
     * @return ModelFile|null
     */
    public function getFileSup(): ?ModelFile
    {
        return $this->fileSup;
    }

    /**
     * @param ModelFile $fileSup
     */
    public function setFileSup(ModelFile $fileSup = null)
    {
        $this->fileSup = $fileSup;
    }

}
