<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model;

use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ShippingAutoSup
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Shop\Repository\ShippingAutoSupRepository")
 * @ORM\Table(name="shop_shipping_auto_sup")
 * @ORM\HasLifecycleCallbacks()
 */
class ShippingAutoSup
{
    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @ORM\Column(type="string", nullable=true)
     * @var string
     */
    private $postal;

    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $city;

    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $county;

    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $country;

    /**
     * @ORM\Column(type="boolean")
     * @var boolean
     */
    private $verification;

    /**
     * @ORM\Column(type="string")
     *
     * @var string
     */
    private $oldName;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->verification = 0;
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getPostal(): ?string
    {
        return $this->postal;
    }

    /**
     * @param string $postal
     */
    public function setPostal(?string $postal)
    {
        $this->postal = $postal;
    }

    /**
     * @return string
     */
    public function getCity(): ?string
    {
        return $this->city;
    }

    /**
     * @param string $city
     */
    public function setCity(?string $city = null)
    {
        $this->city = $city;
    }

    /**
     * @return string
     */
    public function getCounty(): ?string
    {
        return $this->county;
    }

    /**
     * @param string $county
     */
    public function setCounty(?string $county)
    {
        $this->county = $county;
    }

    /**
     * @return string
     */
    public function getCountry(): ?string
    {
        return $this->country;
    }

    /**
     * @param string $country
     */
    public function setCountry(?string $country)
    {
        $this->country = $country;
    }

    /**
     * @return bool
     */
    public function isVerification(): bool
    {
        return $this->verification;
    }

    /**
     * @param bool $verification
     */
    public function setVerification(bool $verification)
    {
        $this->verification = $verification;
    }

    /**
     * @return string
     */
    public function getOldName(): ?string
    {
        return $this->oldName;
    }

    /**
     * @param string $oldName
     */
    public function setOldName(string $oldName)
    {
        $this->oldName = $oldName;
    }
}
