<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model;

use CpCreation\VitiCore\Behavior\HasDisable;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Disable;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class DeliveryMethodCategory
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Shop\Repository\DeliveryMethodCategoryRepository")
 * @ORM\Table(name="shop_delivery_method_category")
 * @ORM\HasLifecycleCallbacks()
 */
class DeliveryMethodCategory implements HasTranslatable, HasDisable
{
    use Translatable, Disable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @ORM\Column(type="integer")
     * @Gedmo\SortablePosition()
     *
     * @var integer
     */
    private $position;

    /**
     * @ORM\Column(type="integer")
     * @Assert\NotBlank()
     *
     * @var integer
     */
    private $qtyAt;

    /**
     * @ORM\OneToMany(targetEntity="DeliveryMethod", mappedBy="category", orphanRemoval=true)
     * @ORM\JoinColumn(name="method_category_id", referencedColumnName="id", nullable=true)
     * @ORM\OrderBy({"position" = "ASC"})
     * @var Collection<Product>
     */
    private $methods;

    /**
     * DeliveryMethod constructor.
     * @throws \Exception
     */
    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->disabled = false;
        $this->methods = new ArrayCollection();
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getPosition(): ?int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position)
    {
        $this->position = $position;
    }

    /**
     * @return int
     */
    public function getQtyAt(): ?int
    {
        return $this->qtyAt;
    }

    /**
     * @param int $qtyAt
     */
    public function setQtyAt(int $qtyAt)
    {
        $this->qtyAt = $qtyAt;
    }

    /**
     * @return Collection
     */
    public function getMethods(): ?Collection
    {
        return $this->methods;
    }
}