<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Repository;

use CpCreation\VitiCore\Product\Model\ProductVariant;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\Persistence\ManagerRegistry;

class ProductVariantRepository extends BaseRepository
{
    /**
     * ProductVariantRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ProductVariant::class);
    }

    public function findAllPublishQuery()
    {
        $qb = $this->createQueryBuilder('pv')
                   ->innerJoin('pv.product', 'p')
                   ->andWhere('p.disabled = FALSE')
                   ->andWhere('pv.unPublished = FALSE')
                   ->orderBy('p.position', 'ASC')
            ;

        return $qb;

    }
}
