<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Repository;

use CpCreation\VitiCore\Product\Model\ProductDegressive;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\ORM\Query\Expr\Join;
use Doctrine\Persistence\ManagerRegistry;

class ProductDegressiveRepository extends BaseRepository
{
    /**
     * ProductDegressiveRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ProductDegressive::class);
    }

    /**
     * @return mixed
     */
    public function findOrder()
    {
        $qb = $this
            ->createQueryBuilder('p')
            ->innerJoin('p.types', 't')
            ->innerJoin('t.translations', 'tr')
            ->addOrderBy('tr.name')
            ->addOrderBy('p.qtyAt')
            ->getQuery()
            ->getResult();

        return $qb;
    }

    /**
     * @param int          $qty
     * @param string       $type
     * @param ProductPriceGroup $group
     * @return mixed
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findByQuantityAndByTypeAndByGroup(int $qty, string $type, ProductPriceGroup $group)
    {
        $qb = $this
            ->createQueryBuilder('p')
            ->innerJoin('p.types','t', Join::WITH,'t.id = :type')
            ->innerJoin('p.groups','g',Join::WITH,'g.id = :group')
            ->andwhere('p.qtyOf < :qty')
            ->andwhere('p.qtyAt >= :qty')
            ->setParameter('qty', $qty)
            ->setParameter('type', $type)
            ->setParameter('group', $group->getId()->toString())
            ->getQuery()
            ->setMaxResults(1)
            ->getOneOrNullResult();

        return $qb;
    }

    /**
     * @param int          $qty
     * @param string       $type
     * @param ProductPriceGroup $group
     * @return mixed
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findByQuantityAndByTypeAndByGroupAndByEquivalency(int $qty, string $type, ProductPriceGroup $group)
    {
        $qb = $this
            ->createQueryBuilder('p')
            ->innerJoin('p.types','t', Join::WITH,'t.id = :type')
            ->innerJoin('p.groups','g',Join::WITH,'g.id = :group')
            ->andwhere('p.qtyOf < :qty')
            ->andwhere('p.qtyAt >= :qty')
            ->andwhere('p.equivalency = TRUE')
            ->setParameter('qty', $qty)
            ->setParameter('type', $type)
            ->setParameter('group', $group->getId()->toString())
            ->getQuery()
            ->setMaxResults(1)
            ->getOneOrNullResult();

        return $qb;
    }

}
