<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model;

use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Symfony\Component\Validator\Constraints as Assert;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class ProductType
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Product\Repository\ProductTypeRepository")
 * @ORM\Table(name="product_type")
 * @ORM\HasLifecycleCallbacks()
 */
class ProductType implements HasTimestamp, HasTranslatable
{
    use Timestamp, Translatable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(type="integer")
     * @Gedmo\SortablePosition()
     */
    private $position;

    /**
     * @ORM\Column(type="decimal", precision=5, scale=2, nullable=true)
     *
     * @var float
     */
    private $volume;

    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @var string
     */
    private $unity;

    /**
     * @ORM\Column(type="integer")
     * @Assert\NotBlank()
     *
     * @var integer
     */
    private $multipleQuantityCart;

    /**
     * @ORM\Column(type="decimal", precision=4, scale=2)
     * @Assert\NotBlank()
     *
     * @var float
     */
    private $equivalencyManu;

    /**
     * @ORM\Column(type="decimal", precision=4, scale=2)
     * @Assert\NotBlank()
     *
     * @var float
     */
    private $equivalency;

    /**
     * @ORM\Column(type="decimal", precision=4, scale=2)
     * @Assert\NotBlank()
     *
     * @var float
     */
    private $equivalencyFreeShipping;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $equivalencyDefault;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $equivalencyOnShipping;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $equivalencyDefaultQuantity;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $equivalencyOnFreeShipping;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->equivalencyOnShipping = 0 ;
        $this->equivalencyOnFreeShipping = 0 ;
        $this->equivalencyDefault = 0 ;
        $this->equivalencyDefaultQuantity = 0;
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @param Uuid $id
     */
    public function setId(Uuid $id): void
    {
        $this->id = $id;
    }

    /**
     * @return int
     */
    public function getPosition(): ?int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position): void
    {
        $this->position = $position;
    }

    /**
     * @return float
     */
    public function getVolume(): ?float
    {
        return $this->volume;
    }

    /**
     * @param float $volume
     */
    public function setVolume(float $volume = null): void
    {
        $this->volume = $volume;
    }

    /**
     * @return string
     */
    public function getUnity(): ?string
    {
        return $this->unity;
    }

    /**
     * @param string $unity
     */
    public function setUnity(string $unity = null): void
    {
        $this->unity = $unity;
    }

    /**
     * @return float
     */
    public function getEquivalencyManu(): ?float
    {
        return $this->equivalencyManu;
    }

    /**
     * @param float $equivalencyManu
     */
    public function setEquivalencyManu(float $equivalencyManu = null): void
    {
        $this->equivalencyManu = $equivalencyManu;
    }

    /**
     * @return float
     */
    public function getEquivalency(): ?float
    {
        return $this->equivalency;
    }

    /**
     * @param float $equivalency
     */
    public function setEquivalency(float $equivalency = null): void
    {
        $this->equivalency = $equivalency;
    }

    /**
     * @return float
     */
    public function getEquivalencyFreeShipping(): ?float
    {
        return $this->equivalencyFreeShipping;
    }

    /**
     * @param float $equivalencyFreeShipping
     */
    public function setEquivalencyFreeShipping(float $equivalencyFreeShipping = null): void
    {
        $this->equivalencyFreeShipping = $equivalencyFreeShipping;
    }


    /**
     * @return bool
     */
    public function isEquivalencyDefault(): bool
    {
        return $this->equivalencyDefault;
    }

    /**
     * @param bool $equivalencyDefault
     */
    public function setEquivalencyDefault(bool $equivalencyDefault): void
    {
        $this->equivalencyDefault = $equivalencyDefault;
    }

    /**
     * @return bool
     */
    public function isEquivalencyOnShipping(): bool
    {
        return $this->equivalencyOnShipping;
    }

    /**
     * @param bool $equivalencyOnShipping
     */
    public function setEquivalencyOnShipping(bool $equivalencyOnShipping): void
    {
        $this->equivalencyOnShipping = $equivalencyOnShipping;
    }

    /**
     * @return bool
     */
    public function isEquivalencyOnFreeShipping(): bool
    {
        return $this->equivalencyOnFreeShipping;
    }

    /**
     * @param bool $equivalencyOnFreeShipping
     */
    public function setEquivalencyOnFreeShipping(bool $equivalencyOnFreeShipping): void
    {
        $this->equivalencyOnFreeShipping = $equivalencyOnFreeShipping;
    }

    /**
     * @return bool
     */
    public function isEquivalencyDefaultQuantity(): bool
    {
        return $this->equivalencyDefaultQuantity;
    }

    /**
     * @param bool $equivalencyDefaultQuantity
     */
    public function setEquivalencyDefaultQuantity(bool $equivalencyDefaultQuantity)
    {
        $this->equivalencyDefaultQuantity = $equivalencyDefaultQuantity;
    }

    /**
     * @return int
     */
    public function getMultipleQuantityCart(): ?int
    {
        return $this->multipleQuantityCart;
    }

    /**
     * @param int $multipleQuantityCart
     */
    public function setMultipleQuantityCart(int $multipleQuantityCart = null): void
    {
        $this->multipleQuantityCart = $multipleQuantityCart;
    }
}