<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model;

use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Symfony\Component\Validator\Constraints as Assert;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class ProductPriceGroup
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository")
 * @ORM\Table(name="product_price_group")
 * @ORM\HasLifecycleCallbacks()
 */
class ProductPriceGroup implements HasTimestamp
{
    use Timestamp;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @ORM\Column(type="text", length=255)
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $name;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $byDefault;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $viewHT;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $freeShipping;

    /**
     * @ORM\OneToOne(targetEntity="ProductPriceCode", mappedBy="group", cascade={"remove"})
     *
     * @var ProductPriceCode
     */
    private $code;

    /**
     * @ORM\OneToMany(targetEntity="ProductPrice", cascade={"remove"}, mappedBy="group")
     *
     * @var ArrayCollection
     */
    protected $prices;

    /**
     * @Gedmo\SortablePosition()
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int
     */
    private $position;

    public function __construct()
    {
        $this->id      = Uuid::uuid4();
        $this->byDefault = false;
        $this->viewHT = false;
        $this->freeShipping = false;
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @return bool
     */
    public function isByDefault(): bool
    {
        return $this->byDefault;
    }

    /**
     * @param bool $byDefault
     */
    public function setByDefault(bool $byDefault): void
    {
        $this->byDefault = $byDefault;
    }

    /**
     * @return bool
     */
    public function isViewHT(): bool
    {
        return $this->viewHT;
    }

    /**
     * @return bool
     */
    public function isFreeShipping(): bool
    {
        return $this->freeShipping;
    }

    /**
     * @param bool $freeShipping
     */
    public function setFreeShipping(bool $freeShipping)
    {
        $this->freeShipping = $freeShipping;
    }

    /**
     * @param bool $viewHT
     */
    public function setViewHT(bool $viewHT): void
    {
        $this->viewHT = $viewHT;
    }

    /**
     * @param string $name
     */
    public function setName(string $name = null): void
    {
        $this->name = $name;
    }

    /**
     * @return ProductPriceCode
     */
    public function getCode(): ProductPriceCode
    {
        return $this->code;
    }

    /**
     * @return int
     */
    public function getPosition(): ?int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position)
    {
        $this->position = $position;
    }
}
