<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model;

use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ProductPriceCode
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository")
 * @ORM\Table(name="product_price_code")
 * @ORM\HasLifecycleCallbacks()
 */
class ProductPriceCode implements HasTimestamp
{
    use Timestamp;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @ORM\Column(type="text", length=255)
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $code;

    /**
     * @ORM\OneToOne(targetEntity="ProductPriceGroup", inversedBy="code", cascade={"remove"})
     * @ORM\JoinColumn(name="group_id", referencedColumnName="id")
     * @Assert\NotBlank()
     *
     * @var ProductPriceGroup
     */
    private $group;

    public function __construct()
    {
        $this->id          = Uuid::uuid4();
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode(string $code = null): void
    {
        $this->code = $code;
    }

    /**
     * @return ProductPriceGroup
     */
    public function getGroup(): ?ProductPriceGroup
    {
        return $this->group;
    }

    /**
     * @param ProductPriceGroup $group
     */
    public function setGroup(ProductPriceGroup $group = null): void
    {
        $this->group = $group;
    }

}
