<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\News\Model;


use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Ramsey\Uuid\Uuid;

/**
 * Class Category
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\News\Repository\CategoryRepository")
 * @ORM\Table(name="news_category")
 * @ORM\HasLifecycleCallbacks()
 */
class Category implements HasTranslatable
{
    use Translatable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @Gedmo\SortablePosition()
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int
     */
    private $position;

    /**
     * @ORM\OneToMany(targetEntity="News", mappedBy="category")
     * @ORM\OrderBy({"publishedAt"="DESC"})
     * @var Collection<News>
     */
    private $news;

    public function __construct()
    {
        $this->id     = Uuid::uuid4();
        $this->news = new ArrayCollection();
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getPosition(): ?int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position)
    {
        $this->position = $position;
    }

    /**
     * @return Collection
     */
    public function getNews(): Collection
    {
        return $this->news;
    }

}