<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Media\Model;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class File
 *
 * @ORM\Entity()
 * @ORM\HasLifecycleCallbacks()
 */
class File extends Media
{
    /**
     * @var UploadedFile
     * 
     * @Assert\File(
     *     maxSize = "5M",
     *     mimeTypes = {"application/pdf", "application/x-pdf", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "text/plain", "text/csv"},
     *     maxSizeMessage = "Le fichier est trop volumineux"
     * )
     */
    private $file;

    /**
     * @return UploadedFile
     */
    public function getFile(): ?UploadedFile
    {
        return $this->file;
    }

    /**
     * @param UploadedFile $file
     */
    public function setFile(UploadedFile $file): void
    {
        $this->file = $file;
    }
}

