<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Library\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class LibraryTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="library_library_translation")
 */
class LibraryTranslation
{
    use Translation;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $title;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $legend;

    /**
     * @ORM\Column(type="text")
     * @Gedmo\Slug(fields={"title"})
     *
     * @var string
     */
    private $slug;

    /**
     * @return string
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }

    /**
     * @param string $title
     */
    public function setTitle(string $title = null)
    {
        $this->title = $title;
    }

    /**
     * @return string
     */
    public function getLegend(): ?string
    {
        return $this->legend;
    }

    /**
     * @param string $legend
     */
    public function setLegend(string $legend = null)
    {
        $this->legend = $legend;
    }

    /**
     * @return string
     */
    public function getSlug(): ?string
    {
        return $this->slug;
    }

    /**
     * @param string $slug
     */
    public function setSlug(string $slug = null)
    {
        $this->slug = $slug;
    }


}