<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Depot\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class DepotTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="depot_depot_translation")
 */
class DepotTranslation
{
    use Translation;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $name;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $description;

    /**
     * @return string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name = null)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription(string $description = null)
    {
        $this->description = $description;
    }

}
