<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Contact\Model;

use CpCreation\VitiCore\Behavior\HasFile;
use CpCreation\VitiCore\Behavior\HasImage;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\File;
use CpCreation\VitiCore\Behavior\Impl\Image;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Contact
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Contact\Repository\ContactRepository")
 * @ORM\Table(name="contact_contact")
 * @ORM\HasLifecycleCallbacks()
 */
class Contact implements HasTimestamp, HasFile, HasImage
{
    use Timestamp, File, Image;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @ORM\Column(type="text")
     *
     * @var string
     */
    private $company;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $firstname;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $lastname;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $address;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $postal;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $city;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $phone1;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $phone2;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $phone3;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     * @Assert\Email()
     *
     * @var string
     */
    private $emailFrom;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     * @Assert\Email()
     *
     * @var string
     */
    private $emailToMessage;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     * @Assert\Email()
     *
     * @var string
     */
    private $emailToShop;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\Url()
     *
     * @var string
     */
    private $facebook;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\Url()
     *
     * @var string
     */
    private $instagram;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\Url()
     *
     * @var string
     */
    private $twitter;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $recaptcha;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $recaptchaKeyPublic;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $recaptchaKeyPrivate;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->recaptcha = false;
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @param Uuid $id
     */
    public function setId(Uuid $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getCompany(): ?string
    {
        return $this->company;
    }

    /**
     * @param string $company
     */
    public function setCompany(string $company): void
    {
        $this->company = $company;
    }

    /**
     * @return string
     */
    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    /**
     * @param string $firstname
     */
    public function setFirstname(string $firstname): void
    {
        $this->firstname = $firstname;
    }

    /**
     * @return string
     */
    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    /**
     * @param string $lastname
     */
    public function setLastname(string $lastname): void
    {
        $this->lastname = $lastname;
    }

    /**
     * @return string
     */
    public function getPostal(): ?string
    {
        return $this->postal;
    }

    /**
     * @param string $postal
     */
    public function setPostal(string $postal): void
    {
        $this->postal = $postal;
    }

    /**
     * @return string
     */
    public function getCity(): ?string
    {
        return $this->city;
    }

    /**
     * @param string $city
     */
    public function setCity(string $city): void
    {
        $this->city = $city;
    }

    /**
     * @return string
     */
    public function getAddress(): ?string
    {
        return $this->address;
    }

    /**
     * @param string $address
     */
    public function setAddress(string $address): void
    {
        $this->address = $address;
    }

    /**
     * @return string
     */
    public function getPhone1(): ?string
    {
        return $this->phone1;
    }

    /**
     * @param string $phone1
     */
    public function setPhone1(string $phone1): void
    {
        $this->phone1 = $phone1;
    }

    /**
     * @return string
     */
    public function getPhone2(): ?string
    {
        return $this->phone2;
    }

    /**
     * @param string $phone2
     */
    public function setPhone2(string $phone2 = null): void
    {
        $this->phone2 = $phone2;
    }

    /**
     * @return string
     */
    public function getPhone3(): ?string
    {
        return $this->phone3;
    }

    /**
     * @param string|null $phone3
     */
    public function setPhone3(string $phone3 = null)
    {
        $this->phone3 = $phone3;
    }

    /**
     * @return string
     */
    public function getEmailFrom(): ?string
    {
        return $this->emailFrom;
    }

    /**
     * @param string $emailFrom
     */
    public function setEmailFrom(string $emailFrom): void
    {
        $this->emailFrom = $emailFrom;
    }

    /**
     * @return string
     */
    public function getEmailToMessage(): ?string
    {
        return $this->emailToMessage;
    }

    /**
     * @param string $emailToMessage
     */
    public function setEmailToMessage(string $emailToMessage): void
    {
        $this->emailToMessage = $emailToMessage;
    }

    /**
     * @return string
     */
    public function getEmailToShop(): ?string
    {
        return $this->emailToShop;
    }

    /**
     * @param string $emailToShop
     */
    public function setEmailToShop(string $emailToShop): void
    {
        $this->emailToShop = $emailToShop;
    }


    /**
     * @param string $email
     */
    public function setEmail(string $email): void
    {
        $this->email = $email;
    }

    /**
     * @return string
     */
    public function getFacebook(): ?string
    {
        return $this->facebook;
    }

    /**
     * @param string $facebook
     */
    public function setFacebook(string $facebook = null): void
    {
        $this->facebook = $facebook;
    }

    /**
     * @return string
     */
    public function getInstagram(): ?string
    {
        return $this->instagram;
    }

    /**
     * @param string $instagram
     */
    public function setInstagram(string $instagram = null): void
    {
        $this->instagram = $instagram;
    }

    /**
     * @return string
     */
    public function getTwitter(): ?string
    {
        return $this->twitter;
    }

    /**
     * @param string $twitter
     */
    public function setTwitter(string $twitter = null): void
    {
        $this->twitter = $twitter;
    }

    /**
     * @return bool
     */
    public function isRecaptcha(): bool
    {
        return $this->recaptcha;
    }

    /**
     * @param bool $recaptcha
     */
    public function setRecaptcha(bool $recaptcha)
    {
        $this->recaptcha = $recaptcha;
    }

    /**
     * @return string
     */
    public function getRecaptchaKeyPublic(): ?string
    {
        return $this->recaptchaKeyPublic;
    }

    /**
     * @param string $recaptchaKeyPublic
     */
    public function setRecaptchaKeyPublic(string $recaptchaKeyPublic = null)
    {
        $this->recaptchaKeyPublic = $recaptchaKeyPublic;
    }

    /**
     * @return string
     */
    public function getRecaptchaKeyPrivate(): ?string
    {
        return $this->recaptchaKeyPrivate;
    }

    /**
     * @param string $recaptchaKeyPrivate
     */
    public function setRecaptchaKeyPrivate(string $recaptchaKeyPrivate = null)
    {
        $this->recaptchaKeyPrivate = $recaptchaKeyPrivate;
    }
}
