<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Cart\Repository;

use CpCreation\VitiCore\Cart\Model\Promo;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\Persistence\ManagerRegistry;

class PromoRepository extends BaseRepository
{
    /**
     * PaymentMethodRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Promo::class);
    }

    /**
     * @return mixed
     */
    public function findPromoActiv()
    {
        $qb = $this->createQueryBuilder('p')
                   ->andWhere('p.disabled = FALSE')
                   ->andWhere('p.beginAt < :datetime')
                   ->andWhere('p.endAt > :datetime')
                   ->setParameter('datetime', new \DateTime('now'))
                   ->getQuery();

        return $qb->execute();

    }

    /**
     * @param $code
     * @return mixed
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findPromoActivWithCode($code)
    {
        $code = strtoupper($code);
        $qb   = $this->createQueryBuilder('p')
                     ->andWhere('p.disabled = FALSE')
                     ->andWhere('p.title = :code')
                     ->andWhere('p.beginAt < :datetime')
                     ->andWhere('p.endAt > :datetime')
                     ->setParameter('datetime', new \DateTime('now'))
                     ->setParameter('code', $code)
                     ->getQuery()
                     ->setMaxResults(1);

        return $qb->getOneOrNullResult();

    }
}
