<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Cart\Repository;

use CpCreation\VitiCore\Cart\Model\PaymentMethod;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\Persistence\ManagerRegistry;

class PaymentMethodRepository extends BaseRepository
{
    /**
     * PaymentMethodRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, PaymentMethod::class);
    }

    public function findByDisabledQuery()
    {
        $qb = $this->createQueryBuilder('p')
                   ->andWhere('p.disabled = FALSE');

        return $qb;
    }
}