<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Cart\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class PaymentMethodTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="cart_payment_method_translation")
 */
class PaymentMethodTranslation
{
    use Translation;

    /**
     * @ORM\Column(type="json")
     * @Assert\NotBlank(groups={"step2"})
     *
     * @var array
     */
    private $configuration;

    /**
     * @return array
     */
    public function getConfiguration(): ?array
    {
        return $this->configuration;
    }

    /**
     * @param array $configuration
     */
    public function setConfiguration(array $configuration): void
    {
        $this->configuration = $configuration;
    }
}
