<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Cart\Model;

use CpCreation\VitiCore\Behavior\HasDisable;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Disable;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class PaymentMethod
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Cart\Repository\PaymentMethodRepository")
 * @ORM\Table(name="cart_payment_method")
 * @ORM\HasLifecycleCallbacks()
 */
class PaymentMethod implements HasDisable, HasTimestamp, HasTranslatable
{
    use Disable, Timestamp, Translatable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank(groups={"step1"})
     *
     * @var string
     */
    private $method;


    public function __construct()
    {
        $this->id    = Uuid::uuid4();
        $this->disabled = false;
    }

    /**
     * @return Uuid
     */
    public function getId(): ?Uuid
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getMethod(): ?string
    {
        return $this->method;
    }

    /**
     * @param string $method
     */
    public function setMethod(string $method): void
    {
        $this->method = $method;
    }
}