<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Cart\Model;

use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Symfony\Component\Intl\Countries;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class DeliveryAddress
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Cart\Repository\InvoiceAddressRepository")
 * @ORM\Table(name="cart_invoice_address")
 * @ORM\HasLifecycleCallbacks()
 */
class InvoiceAddress
{
    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $company;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\NotBlank(groups={"checkout"})
     *
     * @var string
     */
    private $lastname;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\NotBlank(groups={"checkout"})
     *
     * @var string
     */
    private $firstname;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\NotBlank(groups={"checkout"})
     *
     * @var string
     */
    private $street;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\NotBlank(groups={"checkout"})
     *
     * @var string
     */
    private $postalCode;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\NotBlank(groups={"checkout"})
     *
     * @var string
     */
    private $city;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\NotBlank(groups={"checkout"})
     *
     * @var string
     */
    private $country;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\NotBlank(groups={"checkout"})
     * @Assert\Email(groups={"checkout"})
     *
     * @var string
     */
    private $email;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\NotBlank(groups={"checkout"})
     *
     * @var string
     */
    private $phone;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getCompany(): ?string
    {
        return $this->company;
    }

    /**
     * @param string $company
     */
    public function setCompany(string $company = null)
    {
        $this->company = $company;
    }

    /**
     * @return string
     */
    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    /**
     * @param string $lastname
     */
    public function setLastname(string $lastname = null )
    {
        $this->lastname = $lastname;
    }

    /**
     * @return string
     */
    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    /**
     * @param string $firstname
     */
    public function setFirstname(string $firstname = null)
    {
        $this->firstname = $firstname;
    }

    /**
     * @return string
     */
    public function getStreet(): ?string
    {
        return $this->street;
    }

    /**
     * @param string $street
     */
    public function setStreet(string $street = null)
    {
        $this->street = $street;
    }

    /**
     * @return string
     */
    public function getPostalCode(): ?string
    {
        return $this->postalCode;
    }

    /**
     * @param string $postalCode
     */
    public function setPostalCode(string $postalCode = null)
    {
        $this->postalCode = $postalCode;
    }

    /**
     * @return string
     */
    public function getCity(): ?string
    {
        return $this->city;
    }

    /**
     * @param string $city
     */
    public function setCity(string $city = null)
    {
        $this->city = $city;
    }

    /**
     * @return string
     */
    public function getCountry(): ?string
    {
        return $this->country;
    }

    /**
     * @param string $country
     */
    public function setCountry(string $country = null)
    {
        $this->country = $country;
    }

    /**
     * @return string
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail(string $email = null)
    {
        $this->email = $email;
    }

    /**
     * @return string
     */
    public function getPhone(): ?string
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     */
    public function setPhone(string $phone = null)
    {
        $this->phone = $phone;
    }

    public function getCountryName(): ?string
    {
        if (!$this->getCountry())
        {
            return null;
        }

        return Countries::getName($this->getCountry());
    }
}
