<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Cart\Model;

use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Product\Model\ProductVariant;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class CartItem
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Cart\Repository\CartItemRepository")
 * @ORM\Table(name="cart_cart_item")
 * @ORM\HasLifecycleCallbacks()
 */
class CartItem implements HasTimestamp
{
    use Timestamp;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var Uuid
     */
    private $id;

    /**
     * @ORM\Column(type="integer")
     * @Assert\NotBlank()
     *
     * @var integer
     */
    private $quantity;

    /**
     * @var Cart
     *
     * @ORM\ManyToOne(targetEntity="Cart", inversedBy="items")
     * @ORM\JoinColumn(name="cart_cart_id", referencedColumnName="id", onDelete="CASCADE")
     */
    private $cart;

    /**
     * @ORM\Column(type="integer")
     *
     * @var integer
     */
    private $price;

    /**
     * @var ProductVariant
     *
     * @ORM\ManyToOne(targetEntity="CpCreation\VitiCore\Product\Model\ProductVariant")
     * @ORM\JoinColumn(name="product_variant_id", referencedColumnName="id")
     * @Assert\NotBlank()
     */
    private $variant;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @return integer
     */
    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    /**
     * @param integer $quantity
     */
    public function setQuantity(int $quantity): void
    {
        $this->quantity = $quantity;
    }

    /**
     * @return ProductVariant
     */
    public function getVariant(): ?ProductVariant
    {
        return $this->variant;
    }

    /**
     * @param ProductVariant $variant
     */
    public function setVariant(ProductVariant $variant): void
    {
        $this->variant = $variant;
    }

    /**
     * @return Cart
     */
    public function getCart(): Cart
    {
        return $this->cart;
    }

    /**
     * @param Cart $cart
     */
    public function setCart(Cart $cart): void
    {
        $this->cart = $cart;
    }

    /**
     * @return int
     */
    public function getPrice(): int
    {
        return $this->price;
    }

    /**
     * @param int $price
     */
    public function setPrice(int $price): void
    {
        $this->price = $price;
    }

    public function getTotal()
    {

        return $this->quantity * $this->getPrice();
    }

}