<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils;

use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Cart\Model\CartItem;
use CpCreation\VitiCore\Product\Model\Product;
use CpCreation\VitiCore\Product\Model\ProductPrice;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Model\ProductVariant;
use CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Product\Repository\ProductRepository;
use CpCreation\VitiCore\Shop\Model\ShippingCountry;
use CpCreation\VitiCore\Shop\Repository\ShippingCountryRepository;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Routing\RouterInterface;

class PriceGroupWithCookie
{
    /**
     * @var SessionInterface
     */
    private $session;

    /**
     * @var ProductRepository
     */
    private $productRepository;

    /**
     * @var ProductPriceGroupRepository
     */
    private $productPriceGroupRepository;

    /**
     * @var ProductPriceCodeRepository
     */
    private $productPriceCodeRepository;
    /**
     * @var RequestStack
     */
    private $request;

    private $shippingCountryRepository;

    /**
     * @var RouterInterface
     */
    private $router;

    public function __construct(ProductRepository $productRepository,
        ProductPriceGroupRepository $productPriceGroupRepository,
        ProductPriceCodeRepository $productPriceCodeRepository,
        RouterInterface $router,
        SessionInterface $session,
        ShippingCountryRepository $shippingCountryRepository,
        RequestStack $request
    ) {
        $this->productPriceGroupRepository = $productPriceGroupRepository;
        $this->productRepository           = $productRepository;
        $this->productPriceCodeRepository  = $productPriceCodeRepository;
        $this->shippingCountryRepository   = $shippingCountryRepository;
        $this->session                     = $session;
        $this->request                     = $request;
        $this->router                      = $router;
    }

    public function findAllPublish(Cart $cart = null)
    {
        $countryDefault = $this->shippingCountryRepository->findTvaByDefault();
        if ($this->request->getCurrentRequest()->cookies->has('PRICE')) {
            $priceCode = $this->productPriceCodeRepository->findOneBy(['id' => $this->request->getCurrentRequest()->cookies->get('PRICE')]);
            if (!$priceCode) {
                $response = new RedirectResponse($this->router->generate('shop'));

                return $response;
            }
            $priceGroupId = $priceCode->getGroup()->getId()->toString();
            $products     = $this->productRepository->findOnlyShop($priceCode->getGroup());
        } else {
            /** @var ProductPriceGroup $groupPriceDefault */
            $priceGroupDefault = $this->productPriceGroupRepository->findOneBy(['byDefault' => true]);
            $priceGroupId      = $priceGroupDefault->getId()->toString();
            $products          = $this->productRepository->findOnlyShop($priceGroupDefault);
        }

        if ($countryDefault && $cart) {
            if ($countryDefault->getCode() !== $cart->getInvoiceAddress()->getCountry()) {
                $taxeCustomer = $countryDefault->getTvaCustomer();
                /** @var Product $product */
                foreach ($products as $product) {
                    /** @var ProductVariant $variant */
                    foreach ($product->getVariants() as $variant) {
                        /** @var ProductPrice $price */
                        foreach ($variant->getPrices() as $price) {
                            if ($price->getGroup()->getId()->toString() === $priceGroupId) {
                                $variant->setPrice(ceil(round(($price->getPrice() / (1 + $taxeCustomer) * 100) / 100)));
                                $variant->setPriceDiscount(null);
                                if ($price->getPriceDiscount()) {
                                    $variant->setPriceDiscount(ceil(round(($price->getPriceDiscount() / (1 + $taxeCustomer) * 100) / 100)));
                                }
                            }
                        }
                    }
                }

                return $products;
            }
        }

        /** @var Product $product */
        foreach ($products as $product) {
            /** @var ProductVariant $variant */
            foreach ($product->getVariants() as $variant) {
                /** @var ProductPrice $price */
                foreach ($variant->getPrices() as $price) {
                    if ($price->getGroup()->getId()->toString() === $priceGroupId) {
                        $variant->setPrice($price->getPrice());
                        $variant->setPriceDiscount($price->getPriceDiscount());
                    }
                }
            }
        }

        return $products;
    }

    public function convertItemsPriceByCountry(Cart $cart = null)
    {
        $countryDefault = $this->shippingCountryRepository->findTvaByDefault();
        if ($this->request->getCurrentRequest()->cookies->has('PRICE')) {
            $priceCode    = $this->productPriceCodeRepository->findOneBy(['id' => $this->request->getCurrentRequest()->cookies->get('PRICE')]);
            $priceGroupId = $priceCode->getGroup()->getId()->toString();
        } else {
            /** @var ProductPriceGroup $groupPriceDefault */
            $priceGroupDefault = $this->productPriceGroupRepository->findOneBy(['byDefault' => true]);
            $priceGroupId      = $priceGroupDefault->getId()->toString();
        }
        if ($countryDefault->getCode() !== $cart->getInvoiceAddress()->getCountry()) {
            $taxeCustomer = $countryDefault->getTvaCustomer();
            /** @var CartItem $item */
            foreach ($cart->getItems() as $item) {
                /** @var ProductPrice $price */
                foreach ($item->getVariant()->getPrices() as $price) {
                    if ($price->getGroup()->getId()->toString() === $priceGroupId) {
                        if ($price->getPriceDiscount()) {
                            $item->setPrice(ceil(round(($price->getPriceDiscount() / (1 + $taxeCustomer) * 100) / 100)));
                        }
                        $item->setPrice(ceil(round(($price->getPrice() / (1 + $taxeCustomer) * 100) / 100)));
                    }
                }
            }

            return $cart;
        }

        return $cart;
    }
}
